/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.writer;

import com.google.gson.JsonObject;
import com.liferay.apio.architect.impl.internal.alias.BaseRepresentorFunction;
import com.liferay.apio.architect.impl.internal.alias.PathFunction;
import com.liferay.apio.architect.impl.internal.alias.RepresentorFunction;
import com.liferay.apio.architect.impl.internal.alias.ResourceNameFunction;
import com.liferay.apio.architect.impl.internal.alias.SingleModelFunction;
import com.liferay.apio.architect.impl.internal.list.FunctionalList;
import com.liferay.apio.architect.impl.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.impl.internal.message.json.SingleModelMessageMapper;
import com.liferay.apio.architect.impl.internal.request.RequestInfo;
import com.liferay.apio.architect.impl.internal.single.model.SingleModelImpl;
import com.liferay.apio.architect.impl.internal.unsafe.Unsafe;
import com.liferay.apio.architect.impl.internal.url.URLCreator;
import com.liferay.apio.architect.impl.internal.writer.FieldsWriter;
import com.liferay.apio.architect.impl.internal.writer.util.WriterUtil;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.representor.BaseRepresentor;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.uri.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class SingleModelWriter<T> {
    private final JSONObjectBuilder _jsonObjectBuilder;
    private final PathFunction _pathFunction;
    private final RepresentorFunction _representorFunction;
    private final RequestInfo _requestInfo;
    private final ResourceNameFunction _resourceNameFunction;
    private final SingleModel<T> _singleModel;
    private final SingleModelFunction _singleModelFunction;
    private final SingleModelMessageMapper<T> _singleModelMessageMapper;

    public static <T> SingleModelWriter<T> create(Function<Builder<T>, SingleModelWriter<T>> function) {
        return function.apply(new Builder());
    }

    public SingleModelWriter(Builder<T> builder) {
        this._pathFunction = ((Builder)builder)._pathFunction;
        this._representorFunction = ((Builder)builder)._representorFunction;
        this._requestInfo = ((Builder)builder)._requestInfo;
        this._resourceNameFunction = ((Builder)builder)._resourceNameFunction;
        this._singleModel = ((Builder)builder)._singleModel;
        this._singleModelMessageMapper = ((Builder)builder)._singleModelMessageMapper;
        this._singleModelFunction = ((Builder)builder)._singleModelFunction;
        this._jsonObjectBuilder = new JSONObjectBuilder();
    }

    public Optional<String> write() {
        Optional<Path> pathOptional = WriterUtil.getPathOptional(this._singleModel, this._pathFunction, this._representorFunction::apply);
        if (!pathOptional.isPresent()) {
            return Optional.empty();
        }
        Optional<FieldsWriter<T>> fieldsWriterOptional = WriterUtil.getFieldsWriter(this._singleModel, null, this._requestInfo, this._representorFunction::apply, this._singleModelFunction, pathOptional.get());
        if (!fieldsWriterOptional.isPresent()) {
            return Optional.empty();
        }
        FieldsWriter<T> fieldsWriter = fieldsWriterOptional.get();
        this._singleModelMessageMapper.onStart(this._jsonObjectBuilder, this._singleModel, this._requestInfo.getHttpHeaders());
        fieldsWriter.writeBooleanFields((field, value) -> this._singleModelMessageMapper.mapBooleanField(this._jsonObjectBuilder, (String)field, (Boolean)value));
        fieldsWriter.writeBooleanListFields((field, value) -> this._singleModelMessageMapper.mapBooleanListField(this._jsonObjectBuilder, (String)field, (List<Boolean>)value));
        fieldsWriter.writeLocalizedStringFields((field, value) -> this._singleModelMessageMapper.mapStringField(this._jsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeNumberFields((field, value) -> this._singleModelMessageMapper.mapNumberField(this._jsonObjectBuilder, (String)field, (Number)value));
        fieldsWriter.writeNumberListFields((field, value) -> this._singleModelMessageMapper.mapNumberListField(this._jsonObjectBuilder, (String)field, (List<Number>)value));
        fieldsWriter.writeRelativeURLFields((field, value) -> this._singleModelMessageMapper.mapStringField(this._jsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeStringFields((field, value) -> this._singleModelMessageMapper.mapStringField(this._jsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeStringListFields((field, value) -> this._singleModelMessageMapper.mapStringListField(this._jsonObjectBuilder, (String)field, (List<String>)value));
        fieldsWriter.writeLinks((fieldName, link) -> this._singleModelMessageMapper.mapLink(this._jsonObjectBuilder, (String)fieldName, (String)link));
        fieldsWriter.writeTypes(types -> this._singleModelMessageMapper.mapTypes(this._jsonObjectBuilder, (List<String>)types));
        fieldsWriter.writeBinaries((field, value) -> this._singleModelMessageMapper.mapLink(this._jsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeSingleURL(url -> this._singleModelMessageMapper.mapSelfURL(this._jsonObjectBuilder, (String)url));
        List operations = this._singleModel.getOperations();
        operations.forEach(operation -> {
            JSONObjectBuilder operationJSONObjectBuilder = new JSONObjectBuilder();
            this._singleModelMessageMapper.onStartOperation(this._jsonObjectBuilder, operationJSONObjectBuilder, (Operation)operation);
            Optional formOptional = operation.getFormOptional();
            formOptional.map(form -> URLCreator.createFormURL(this._requestInfo.getServerURL(), form)).ifPresent(url -> this._singleModelMessageMapper.mapOperationFormURL(this._jsonObjectBuilder, operationJSONObjectBuilder, (String)url));
            this._singleModelMessageMapper.mapOperationMethod(this._jsonObjectBuilder, operationJSONObjectBuilder, operation.getHttpMethod());
            this._singleModelMessageMapper.onFinishOperation(this._jsonObjectBuilder, operationJSONObjectBuilder, (Operation)operation);
        });
        fieldsWriter.writeRelatedModels(singleModel -> WriterUtil.getPathOptional(singleModel, this._pathFunction, this._representorFunction::apply), this::writeEmbeddedModelFields, (resourceURL, embeddedPathElements) -> this._singleModelMessageMapper.mapLinkedResourceURL(this._jsonObjectBuilder, (FunctionalList<String>)embeddedPathElements, (String)resourceURL), (resourceURL, embeddedPathElements) -> this._singleModelMessageMapper.mapEmbeddedResourceURL(this._jsonObjectBuilder, (FunctionalList<String>)embeddedPathElements, (String)resourceURL));
        fieldsWriter.writeRelatedCollections(this._resourceNameFunction, (url, embeddedPathElements) -> this._singleModelMessageMapper.mapLinkedResourceURL(this._jsonObjectBuilder, (FunctionalList<String>)embeddedPathElements, (String)url));
        this._writeNestedResources(this._representorFunction::apply, this._singleModel, null);
        this._singleModelMessageMapper.onFinish(this._jsonObjectBuilder, this._singleModel, this._requestInfo.getHttpHeaders());
        JsonObject jsonObject = this._jsonObjectBuilder.build();
        return Optional.of(jsonObject.toString());
    }

    public <S> void writeEmbeddedModelFields(SingleModel<S> singleModel, FunctionalList<String> embeddedPathElements) {
        this.writeEmbeddedModelFields(singleModel, embeddedPathElements, this._representorFunction::apply);
    }

    public <S> void writeEmbeddedModelFields(SingleModel<S> singleModel, FunctionalList<String> embeddedPathElements, BaseRepresentorFunction baseRepresentorFunction) {
        Optional<Path> pathOptional = WriterUtil.getPathOptional(singleModel, this._pathFunction, baseRepresentorFunction, this._representorFunction, this._singleModel);
        if (!pathOptional.isPresent()) {
            return;
        }
        Optional<FieldsWriter<S>> fieldsWriterOptional = WriterUtil.getFieldsWriter(singleModel, embeddedPathElements, this._requestInfo, baseRepresentorFunction, this._singleModelFunction, pathOptional.get());
        if (!fieldsWriterOptional.isPresent()) {
            return;
        }
        FieldsWriter<S> fieldsWriter = fieldsWriterOptional.get();
        fieldsWriter.writeBooleanFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceBooleanField(this._jsonObjectBuilder, embeddedPathElements, (String)field, (Boolean)value));
        fieldsWriter.writeBooleanListFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceBooleanListField(this._jsonObjectBuilder, embeddedPathElements, (String)field, (List<Boolean>)value));
        fieldsWriter.writeLocalizedStringFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceStringField(this._jsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        fieldsWriter.writeNumberFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceNumberField(this._jsonObjectBuilder, embeddedPathElements, (String)field, (Number)value));
        fieldsWriter.writeNumberListFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceNumberListField(this._jsonObjectBuilder, embeddedPathElements, (String)field, (List<Number>)value));
        fieldsWriter.writeRelativeURLFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceStringField(this._jsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        fieldsWriter.writeStringFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceStringField(this._jsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        fieldsWriter.writeStringListFields((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceStringListField(this._jsonObjectBuilder, embeddedPathElements, (String)field, (List<String>)value));
        fieldsWriter.writeLinks((fieldName, link) -> this._singleModelMessageMapper.mapEmbeddedResourceLink(this._jsonObjectBuilder, embeddedPathElements, (String)fieldName, (String)link));
        fieldsWriter.writeTypes(types -> this._singleModelMessageMapper.mapEmbeddedResourceTypes(this._jsonObjectBuilder, embeddedPathElements, (List<String>)types));
        fieldsWriter.writeBinaries((field, value) -> this._singleModelMessageMapper.mapEmbeddedResourceLink(this._jsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        List operations = singleModel.getOperations();
        operations.forEach(operation -> {
            JSONObjectBuilder operationJSONObjectBuilder = new JSONObjectBuilder();
            this._singleModelMessageMapper.onStartEmbeddedOperation(this._jsonObjectBuilder, operationJSONObjectBuilder, embeddedPathElements, (Operation)operation);
            Optional formOptional = operation.getFormOptional();
            formOptional.ifPresent(form -> {
                String url = URLCreator.createFormURL(this._requestInfo.getServerURL(), form);
                this._singleModelMessageMapper.mapEmbeddedOperationFormURL(this._jsonObjectBuilder, operationJSONObjectBuilder, embeddedPathElements, url);
            });
            this._singleModelMessageMapper.mapEmbeddedOperationMethod(this._jsonObjectBuilder, operationJSONObjectBuilder, embeddedPathElements, operation.getHttpMethod());
            this._singleModelMessageMapper.onFinishEmbeddedOperation(this._jsonObjectBuilder, operationJSONObjectBuilder, embeddedPathElements, (Operation)operation);
        });
        fieldsWriter.writeRelatedModels(embeddedSingleModel -> WriterUtil.getPathOptional(embeddedSingleModel, this._pathFunction, this._representorFunction::apply), this::writeEmbeddedModelFields, (resourceURL, resourceEmbeddedPathElements) -> this._singleModelMessageMapper.mapLinkedResourceURL(this._jsonObjectBuilder, (FunctionalList<String>)resourceEmbeddedPathElements, (String)resourceURL), (resourceURL, resourceEmbeddedPathElements) -> this._singleModelMessageMapper.mapEmbeddedResourceURL(this._jsonObjectBuilder, (FunctionalList<String>)resourceEmbeddedPathElements, (String)resourceURL));
        fieldsWriter.writeRelatedCollections(this._resourceNameFunction, (url, resourceEmbeddedPathElements) -> this._singleModelMessageMapper.mapLinkedResourceURL(this._jsonObjectBuilder, (FunctionalList<String>)resourceEmbeddedPathElements, (String)url));
        this._writeNestedResources(baseRepresentorFunction, singleModel, embeddedPathElements);
    }

    private <S> void _writeNestedResources(BaseRepresentorFunction baseRepresentorFunction, SingleModel<S> singleModel, FunctionalList<String> embeddedPathElements) {
        ((Optional)baseRepresentorFunction.apply(singleModel.getResourceName())).map(Unsafe::unsafeCast).map(BaseRepresentor::getNestedFieldFunctions).map(Collection::stream).orElseGet(Stream::empty).forEach(nestedFieldFunction -> {
            Object mappedModel = nestedFieldFunction.apply(singleModel.getModel());
            FunctionalList<String> embeddedNestedPathElements = new FunctionalList<String>(embeddedPathElements, nestedFieldFunction.getKey());
            this.writeEmbeddedModelFields(new SingleModelImpl<Object>(mappedModel, "", Collections.emptyList()), embeddedNestedPathElements, __ -> Optional.of(nestedFieldFunction.getNestedRepresentor()));
        });
    }

    public static class Builder<T> {
        private PathFunction _pathFunction;
        private RepresentorFunction _representorFunction;
        private RequestInfo _requestInfo;
        private ResourceNameFunction _resourceNameFunction;
        private SingleModel<T> _singleModel;
        private SingleModelFunction _singleModelFunction;
        private SingleModelMessageMapper<T> _singleModelMessageMapper;

        public SingleModelMessageMapperStep singleModel(SingleModel<T> singleModel) {
            this._singleModel = singleModel;
            return new SingleModelMessageMapperStep();
        }

        public class SingleModelMessageMapperStep {
            public PathFunctionStep modelMessageMapper(SingleModelMessageMapper<T> singleModelMessageMapper) {
                Builder.this._singleModelMessageMapper = singleModelMessageMapper;
                return new PathFunctionStep();
            }
        }

        public class SingleModelFunctionStep {
            public BuildStep singleModelFunction(SingleModelFunction singleModelFunction) {
                Builder.this._singleModelFunction = singleModelFunction;
                return new BuildStep();
            }
        }

        public class ResourceNameFunctionStep {
            public RepresentorFunctionStep resourceNameFunction(ResourceNameFunction resourceNameFunction) {
                Builder.this._resourceNameFunction = resourceNameFunction;
                return new RepresentorFunctionStep();
            }
        }

        public class RequestInfoStep {
            public SingleModelFunctionStep requestInfo(RequestInfo requestInfo) {
                Builder.this._requestInfo = requestInfo;
                return new SingleModelFunctionStep();
            }
        }

        public class RepresentorFunctionStep {
            public RequestInfoStep representorFunction(RepresentorFunction representorFunction) {
                Builder.this._representorFunction = representorFunction;
                return new RequestInfoStep();
            }
        }

        public class PathFunctionStep {
            public ResourceNameFunctionStep pathFunction(PathFunction pathFunction) {
                Builder.this._pathFunction = pathFunction;
                return new ResourceNameFunctionStep();
            }
        }

        public class BuildStep {
            public SingleModelWriter<T> build() {
                return new SingleModelWriter(Builder.this);
            }
        }
    }
}

