/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.writer;

import com.google.gson.JsonObject;
import com.liferay.apio.architect.impl.internal.alias.BaseRepresentorFunction;
import com.liferay.apio.architect.impl.internal.alias.PathFunction;
import com.liferay.apio.architect.impl.internal.alias.RepresentorFunction;
import com.liferay.apio.architect.impl.internal.alias.ResourceNameFunction;
import com.liferay.apio.architect.impl.internal.alias.SingleModelFunction;
import com.liferay.apio.architect.impl.internal.list.FunctionalList;
import com.liferay.apio.architect.impl.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.impl.internal.message.json.PageMessageMapper;
import com.liferay.apio.architect.impl.internal.pagination.PageType;
import com.liferay.apio.architect.impl.internal.request.RequestInfo;
import com.liferay.apio.architect.impl.internal.single.model.SingleModelImpl;
import com.liferay.apio.architect.impl.internal.unsafe.Unsafe;
import com.liferay.apio.architect.impl.internal.url.URLCreator;
import com.liferay.apio.architect.impl.internal.writer.FieldsWriter;
import com.liferay.apio.architect.impl.internal.writer.util.WriterUtil;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.pagination.Page;
import com.liferay.apio.architect.representor.BaseRepresentor;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.uri.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class PageWriter<T> {
    private final JSONObjectBuilder _jsonObjectBuilder;
    private final Page<T> _page;
    private final PageMessageMapper<T> _pageMessageMapper;
    private final PathFunction _pathFunction;
    private final RepresentorFunction _representorFunction;
    private final RequestInfo _requestInfo;
    private final ResourceNameFunction _resourceNameFunction;
    private final SingleModelFunction _singleModelFunction;

    public static <T> PageWriter<T> create(Function<Builder<T>, PageWriter<T>> function) {
        return function.apply(new Builder());
    }

    public PageWriter(Builder<T> builder) {
        this._page = ((Builder)builder)._page;
        this._pageMessageMapper = ((Builder)builder)._pageMessageMapper;
        this._pathFunction = ((Builder)builder)._pathFunction;
        this._representorFunction = ((Builder)builder)._representorFunction;
        this._requestInfo = ((Builder)builder)._requestInfo;
        this._resourceNameFunction = ((Builder)builder)._resourceNameFunction;
        this._singleModelFunction = ((Builder)builder)._singleModelFunction;
        this._jsonObjectBuilder = new JSONObjectBuilder();
    }

    public String write() {
        this._pageMessageMapper.onStart(this._jsonObjectBuilder, this._page, this._requestInfo.getHttpHeaders());
        this._pageMessageMapper.mapItemTotalCount(this._jsonObjectBuilder, this._page.getTotalCount());
        Collection items = this._page.getItems();
        this._pageMessageMapper.mapPageCount(this._jsonObjectBuilder, items.size());
        this._writePageURLs();
        String url = this._getCollectionURL();
        this._pageMessageMapper.mapCollectionURL(this._jsonObjectBuilder, url);
        String resourceName = this._page.getResourceName();
        items.forEach(model -> this._writeItem(new SingleModelImpl<Object>(model, resourceName, Collections.emptyList())));
        List operations = this._page.getOperations();
        operations.forEach(operation -> {
            JSONObjectBuilder operationJSONObjectBuilder = new JSONObjectBuilder();
            this._pageMessageMapper.onStartOperation(this._jsonObjectBuilder, operationJSONObjectBuilder, (Operation)operation);
            Optional formOptional = operation.getFormOptional();
            formOptional.map(form -> URLCreator.createFormURL(this._requestInfo.getServerURL(), form)).ifPresent(formURL -> this._pageMessageMapper.mapOperationFormURL(this._jsonObjectBuilder, operationJSONObjectBuilder, (String)formURL));
            this._pageMessageMapper.mapOperationMethod(this._jsonObjectBuilder, operationJSONObjectBuilder, operation.getHttpMethod());
            this._pageMessageMapper.onFinishOperation(this._jsonObjectBuilder, operationJSONObjectBuilder, (Operation)operation);
        });
        this._pageMessageMapper.onFinish(this._jsonObjectBuilder, this._page, this._requestInfo.getHttpHeaders());
        JsonObject jsonObject = this._jsonObjectBuilder.build();
        return jsonObject.toString();
    }

    private String _getCollectionURL() {
        Optional optional = this._page.getPathOptional();
        return optional.map(path -> URLCreator.createNestedCollectionURL(this._requestInfo.getServerURL(), path, this._page.getResourceName())).orElseGet(() -> URLCreator.createCollectionURL(this._requestInfo.getServerURL(), this._page.getResourceName()));
    }

    private void _writeItem(SingleModel<T> singleModel) {
        Optional<Path> pathOptional = WriterUtil.getPathOptional(singleModel, this._pathFunction, this._representorFunction::apply);
        if (!pathOptional.isPresent()) {
            return;
        }
        Optional<FieldsWriter<T>> optional = WriterUtil.getFieldsWriter(singleModel, null, this._requestInfo, this._representorFunction::apply, this._singleModelFunction, pathOptional.get());
        if (!optional.isPresent()) {
            return;
        }
        FieldsWriter<T> fieldsWriter = optional.get();
        JSONObjectBuilder itemJsonObjectBuilder = new JSONObjectBuilder();
        this._pageMessageMapper.onStartItem(this._jsonObjectBuilder, itemJsonObjectBuilder, singleModel, this._requestInfo.getHttpHeaders());
        fieldsWriter.writeBooleanFields((field, value) -> this._pageMessageMapper.mapItemBooleanField(this._jsonObjectBuilder, itemJsonObjectBuilder, (String)field, (Boolean)value));
        fieldsWriter.writeBooleanListFields((field, value) -> this._pageMessageMapper.mapItemBooleanListField(this._jsonObjectBuilder, itemJsonObjectBuilder, (String)field, (List<Boolean>)value));
        fieldsWriter.writeLocalizedStringFields((field, value) -> this._pageMessageMapper.mapItemStringField(this._jsonObjectBuilder, itemJsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeNumberFields((field, value) -> this._pageMessageMapper.mapItemNumberField(this._jsonObjectBuilder, itemJsonObjectBuilder, (String)field, (Number)value));
        fieldsWriter.writeNumberListFields((field, value) -> this._pageMessageMapper.mapItemNumberListField(this._jsonObjectBuilder, itemJsonObjectBuilder, (String)field, (List<Number>)value));
        fieldsWriter.writeRelativeURLFields((field, value) -> this._pageMessageMapper.mapItemStringField(this._jsonObjectBuilder, itemJsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeStringFields((field, value) -> this._pageMessageMapper.mapItemStringField(this._jsonObjectBuilder, itemJsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeStringListFields((field, value) -> this._pageMessageMapper.mapItemStringListField(this._jsonObjectBuilder, itemJsonObjectBuilder, (String)field, (List<String>)value));
        fieldsWriter.writeLinks((fieldName, link) -> this._pageMessageMapper.mapItemLink(this._jsonObjectBuilder, itemJsonObjectBuilder, (String)fieldName, (String)link));
        fieldsWriter.writeTypes(types -> this._pageMessageMapper.mapItemTypes(this._jsonObjectBuilder, itemJsonObjectBuilder, (List<String>)types));
        fieldsWriter.writeBinaries((field, value) -> this._pageMessageMapper.mapItemLink(this._jsonObjectBuilder, itemJsonObjectBuilder, (String)field, (String)value));
        fieldsWriter.writeSingleURL(url -> this._pageMessageMapper.mapItemSelfURL(this._jsonObjectBuilder, itemJsonObjectBuilder, (String)url));
        fieldsWriter.writeRelatedModels(embeddedSingleModel -> WriterUtil.getPathOptional(embeddedSingleModel, this._pathFunction, this._representorFunction::apply), (embeddedSingleModel, embeddedPathElements1) -> this._writeItemEmbeddedModelFields((SingleModel)embeddedSingleModel, (FunctionalList<String>)embeddedPathElements1, itemJsonObjectBuilder), (resourceURL, embeddedPathElements) -> this._pageMessageMapper.mapItemLinkedResourceURL(this._jsonObjectBuilder, itemJsonObjectBuilder, (FunctionalList<String>)embeddedPathElements, (String)resourceURL), (resourceURL, embeddedPathElements) -> this._pageMessageMapper.mapItemEmbeddedResourceURL(this._jsonObjectBuilder, itemJsonObjectBuilder, (FunctionalList<String>)embeddedPathElements, (String)resourceURL));
        fieldsWriter.writeRelatedCollections(this._resourceNameFunction, (url, embeddedPathElements) -> this._pageMessageMapper.mapItemLinkedResourceURL(this._jsonObjectBuilder, itemJsonObjectBuilder, (FunctionalList<String>)embeddedPathElements, (String)url));
        this._writeNestedResources(this._representorFunction::apply, singleModel, itemJsonObjectBuilder, singleModel, null);
        this._pageMessageMapper.onFinishItem(this._jsonObjectBuilder, itemJsonObjectBuilder, singleModel, this._requestInfo.getHttpHeaders());
    }

    private <S> void _writeItemEmbeddedModelFields(SingleModel<S> singleModel, FunctionalList<String> embeddedPathElements, JSONObjectBuilder itemJsonObjectBuilder) {
        this._writeItemEmbeddedModelFields(singleModel, embeddedPathElements, itemJsonObjectBuilder, this._representorFunction::apply, singleModel);
    }

    private <S, U> void _writeItemEmbeddedModelFields(SingleModel<S> singleModel, FunctionalList<String> embeddedPathElements, JSONObjectBuilder itemJsonObjectBuilder, BaseRepresentorFunction baseRepresentorFunction, SingleModel<U> rootSingleModel) {
        Optional<Path> pathOptional = WriterUtil.getPathOptional(singleModel, this._pathFunction, baseRepresentorFunction, this._representorFunction, rootSingleModel);
        if (!pathOptional.isPresent()) {
            return;
        }
        Optional<FieldsWriter<S>> fieldsWriterOptional = WriterUtil.getFieldsWriter(singleModel, embeddedPathElements, this._requestInfo, baseRepresentorFunction, this._singleModelFunction, pathOptional.get());
        if (!fieldsWriterOptional.isPresent()) {
            return;
        }
        FieldsWriter<S> fieldsWriter = fieldsWriterOptional.get();
        fieldsWriter.writeBooleanFields((field, value) -> this._pageMessageMapper.mapItemEmbeddedResourceBooleanField(this._jsonObjectBuilder, itemJsonObjectBuilder, embeddedPathElements, (String)field, (Boolean)value));
        fieldsWriter.writeBooleanListFields((field, value) -> this._pageMessageMapper.mapItemEmbeddedResourceBooleanListField(this._jsonObjectBuilder, itemJsonObjectBuilder, embeddedPathElements, (String)field, (List<Boolean>)value));
        fieldsWriter.writeLocalizedStringFields((field, value) -> this._pageMessageMapper.mapItemEmbeddedResourceStringField(this._jsonObjectBuilder, itemJsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        fieldsWriter.writeNumberFields((field, value) -> this._pageMessageMapper.mapItemEmbeddedResourceNumberField(this._jsonObjectBuilder, itemJsonObjectBuilder, embeddedPathElements, (String)field, (Number)value));
        fieldsWriter.writeNumberListFields((field, value) -> this._pageMessageMapper.mapItemEmbeddedResourceNumberListField(this._jsonObjectBuilder, itemJsonObjectBuilder, embeddedPathElements, (String)field, (List<Number>)value));
        fieldsWriter.writeRelativeURLFields((field, value) -> this._pageMessageMapper.mapItemEmbeddedResourceStringField(this._jsonObjectBuilder, itemJsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        fieldsWriter.writeStringFields((field, value) -> this._pageMessageMapper.mapItemEmbeddedResourceStringField(this._jsonObjectBuilder, itemJsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        fieldsWriter.writeStringListFields((field, value) -> this._pageMessageMapper.mapItemEmbeddedResourceStringListField(this._jsonObjectBuilder, itemJsonObjectBuilder, embeddedPathElements, (String)field, (List<String>)value));
        fieldsWriter.writeLinks((fieldName, link) -> this._pageMessageMapper.mapItemEmbeddedResourceLink(this._jsonObjectBuilder, itemJsonObjectBuilder, embeddedPathElements, (String)fieldName, (String)link));
        fieldsWriter.writeTypes(types -> this._pageMessageMapper.mapItemEmbeddedResourceTypes(this._jsonObjectBuilder, itemJsonObjectBuilder, embeddedPathElements, (List<String>)types));
        fieldsWriter.writeBinaries((field, value) -> this._pageMessageMapper.mapItemEmbeddedResourceLink(this._jsonObjectBuilder, itemJsonObjectBuilder, embeddedPathElements, (String)field, (String)value));
        fieldsWriter.writeRelatedModels(embeddedSingleModel -> WriterUtil.getPathOptional(embeddedSingleModel, this._pathFunction, this._representorFunction::apply), (embeddedSingleModel, embeddedModelEmbeddedPathElements) -> this._writeItemEmbeddedModelFields((SingleModel)embeddedSingleModel, (FunctionalList<String>)embeddedModelEmbeddedPathElements, itemJsonObjectBuilder), (resourceURL, resourceEmbeddedPathElements) -> this._pageMessageMapper.mapItemLinkedResourceURL(this._jsonObjectBuilder, itemJsonObjectBuilder, (FunctionalList<String>)resourceEmbeddedPathElements, (String)resourceURL), (resourceURL, resourceEmbeddedPathElements) -> this._pageMessageMapper.mapItemEmbeddedResourceURL(this._jsonObjectBuilder, itemJsonObjectBuilder, (FunctionalList<String>)resourceEmbeddedPathElements, (String)resourceURL));
        fieldsWriter.writeRelatedCollections(this._resourceNameFunction, (url, resourceEmbeddedPathElements) -> this._pageMessageMapper.mapItemLinkedResourceURL(this._jsonObjectBuilder, itemJsonObjectBuilder, (FunctionalList<String>)resourceEmbeddedPathElements, (String)url));
        this._writeNestedResources(baseRepresentorFunction, singleModel, itemJsonObjectBuilder, rootSingleModel, embeddedPathElements);
    }

    private <S, U> void _writeNestedResources(BaseRepresentorFunction baseRepresentorFunction, SingleModel<U> singleModel, JSONObjectBuilder itemJsonObjectBuilder, SingleModel<S> rootSingleModel, FunctionalList<String> embeddedPathElements) {
        ((Optional)baseRepresentorFunction.apply(singleModel.getResourceName())).map(Unsafe::unsafeCast).map(BaseRepresentor::getNestedFieldFunctions).map(Collection::stream).orElseGet(Stream::empty).forEach(nestedFieldFunction -> {
            Object mappedModel = nestedFieldFunction.apply(singleModel.getModel());
            FunctionalList<String> embeddedNestedPathElements = new FunctionalList<String>(embeddedPathElements, nestedFieldFunction.getKey());
            this._writeItemEmbeddedModelFields(new SingleModelImpl<Object>(mappedModel, "", Collections.emptyList()), embeddedNestedPathElements, itemJsonObjectBuilder, __ -> Optional.of(nestedFieldFunction.getNestedRepresentor()), rootSingleModel);
        });
    }

    private void _writePageURLs() {
        String url = this._getCollectionURL();
        this._pageMessageMapper.mapCurrentPageURL(this._jsonObjectBuilder, URLCreator.createCollectionPageURL(url, this._page, PageType.CURRENT));
        this._pageMessageMapper.mapFirstPageURL(this._jsonObjectBuilder, URLCreator.createCollectionPageURL(url, this._page, PageType.FIRST));
        this._pageMessageMapper.mapLastPageURL(this._jsonObjectBuilder, URLCreator.createCollectionPageURL(url, this._page, PageType.LAST));
        if (this._page.hasNext()) {
            this._pageMessageMapper.mapNextPageURL(this._jsonObjectBuilder, URLCreator.createCollectionPageURL(url, this._page, PageType.NEXT));
        }
        if (this._page.hasPrevious()) {
            this._pageMessageMapper.mapPreviousPageURL(this._jsonObjectBuilder, URLCreator.createCollectionPageURL(url, this._page, PageType.PREVIOUS));
        }
    }

    public static class Builder<T> {
        private Page<T> _page;
        private PageMessageMapper<T> _pageMessageMapper;
        private PathFunction _pathFunction;
        private RepresentorFunction _representorFunction;
        private RequestInfo _requestInfo;
        private ResourceNameFunction _resourceNameFunction;
        private SingleModelFunction _singleModelFunction;

        public PageMessageMapperStep page(Page<T> page) {
            this._page = page;
            return new PageMessageMapperStep();
        }

        public class SingleModelFunctionStep {
            public BuildStep singleModelFunction(SingleModelFunction singleModelFunction) {
                Builder.this._singleModelFunction = singleModelFunction;
                return new BuildStep();
            }
        }

        public class ResourceNameFunctionStep {
            public RepresentorFunctionStep resourceNameFunction(ResourceNameFunction resourceNameFunction) {
                Builder.this._resourceNameFunction = resourceNameFunction;
                return new RepresentorFunctionStep();
            }
        }

        public class RequestInfoStep {
            public SingleModelFunctionStep requestInfo(RequestInfo requestInfo) {
                Builder.this._requestInfo = requestInfo;
                return new SingleModelFunctionStep();
            }
        }

        public class RepresentorFunctionStep {
            public RequestInfoStep representorFunction(RepresentorFunction representorFunction) {
                Builder.this._representorFunction = representorFunction;
                return new RequestInfoStep();
            }
        }

        public class PathFunctionStep {
            public ResourceNameFunctionStep pathFunction(PathFunction pathFunction) {
                Builder.this._pathFunction = pathFunction;
                return new ResourceNameFunctionStep();
            }
        }

        public class PageMessageMapperStep {
            public PathFunctionStep pageMessageMapper(PageMessageMapper<T> pageMessageMapper) {
                Builder.this._pageMessageMapper = pageMessageMapper;
                return new PathFunctionStep();
            }
        }

        public class BuildStep {
            public PageWriter<T> build() {
                return new PageWriter(Builder.this);
            }
        }
    }
}

