/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.writer;

import com.google.gson.JsonObject;
import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.form.FormField;
import com.liferay.apio.architect.impl.internal.message.json.FormMessageMapper;
import com.liferay.apio.architect.impl.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.impl.internal.request.RequestInfo;
import com.liferay.apio.architect.impl.internal.url.URLCreator;
import java.util.List;
import java.util.function.Function;

public class FormWriter {
    private final Form<?> _form;
    private final FormMessageMapper _formMessageMapper;
    private final RequestInfo _requestInfo;

    public static FormWriter create(Function<Builder, FormWriter> function) {
        return function.apply(new Builder());
    }

    public FormWriter(Builder builder) {
        this._form = builder._form;
        this._formMessageMapper = builder._formMessageMapper;
        this._requestInfo = builder._requestInfo;
    }

    public String write() {
        JSONObjectBuilder jsonObjectBuilder = new JSONObjectBuilder();
        this._formMessageMapper.onStart(jsonObjectBuilder, this._form, this._requestInfo.getHttpHeaders());
        String url = URLCreator.createFormURL(this._requestInfo.getServerURL(), this._form);
        this._formMessageMapper.mapFormURL(jsonObjectBuilder, url);
        String title = this._form.getTitle(this._requestInfo.getAcceptLanguage());
        this._formMessageMapper.mapFormTitle(jsonObjectBuilder, title);
        String description = this._form.getDescription(this._requestInfo.getAcceptLanguage());
        this._formMessageMapper.mapFormDescription(jsonObjectBuilder, description);
        List formFields = this._form.getFormFields();
        formFields.forEach(formField -> this._formMessageMapper.mapFormField(jsonObjectBuilder, (FormField)formField));
        this._formMessageMapper.onFinish(jsonObjectBuilder, this._form, this._requestInfo.getHttpHeaders());
        JsonObject jsonObject = jsonObjectBuilder.build();
        return jsonObject.toString();
    }

    public static class Builder {
        private Form _form;
        private FormMessageMapper _formMessageMapper;
        private RequestInfo _requestInfo;

        public FormMessageMapperStep form(Form form) {
            this._form = form;
            return new FormMessageMapperStep();
        }

        public class RequestInfoStep {
            public BuildStep requestInfo(RequestInfo requestInfo) {
                Builder.this._requestInfo = requestInfo;
                return new BuildStep();
            }
        }

        public class FormMessageMapperStep {
            public RequestInfoStep formMessageMapper(FormMessageMapper formMessageMapper) {
                Builder.this._formMessageMapper = formMessageMapper;
                return new RequestInfoStep();
            }
        }

        public class BuildStep {
            public FormWriter build() {
                return new FormWriter(Builder.this);
            }
        }
    }
}

