/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.writer;

import com.liferay.apio.architect.alias.representor.FieldFunction;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.impl.internal.alias.SingleModelFunction;
import com.liferay.apio.architect.impl.internal.list.FunctionalList;
import com.liferay.apio.architect.impl.internal.request.RequestInfo;
import com.liferay.apio.architect.impl.internal.response.control.Embedded;
import com.liferay.apio.architect.impl.internal.response.control.Fields;
import com.liferay.apio.architect.impl.internal.unsafe.Unsafe;
import com.liferay.apio.architect.impl.internal.url.URLCreator;
import com.liferay.apio.architect.related.RelatedCollection;
import com.liferay.apio.architect.related.RelatedModel;
import com.liferay.apio.architect.representor.BaseRepresentor;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.uri.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FieldsWriter<T> {
    private final BaseRepresentor<T> _baseRepresentor;
    private final FunctionalList<String> _embeddedPathElements;
    private final Path _path;
    private final RequestInfo _requestInfo;
    private final SingleModel<T> _singleModel;
    private final SingleModelFunction _singleModelFunction;

    public static <T, S, U> Optional<SingleModel<U>> getSingleModel(RelatedModel<T, S> relatedModel, SingleModel<T> parentSingleModel, SingleModelFunction singleModelFunction) {
        Function identifierFunction = relatedModel.getIdentifierFunction();
        return identifierFunction.andThen(s -> (Optional)singleModelFunction.apply(s, relatedModel.getIdentifierClass())).apply(parentSingleModel.getModel()).map(Unsafe::unsafeCast);
    }

    public FieldsWriter(SingleModel<T> singleModel, RequestInfo requestInfo, BaseRepresentor<T> baseRepresentor, Path path, FunctionalList<String> embeddedPathElements, SingleModelFunction singleModelFunction) {
        this._singleModel = singleModel;
        this._requestInfo = requestInfo;
        this._baseRepresentor = baseRepresentor;
        this._path = path;
        this._embeddedPathElements = embeddedPathElements;
        this._singleModelFunction = singleModelFunction;
    }

    public Predicate<String> getFieldsPredicate() {
        Fields fields = this._requestInfo.getFields();
        return (Predicate)fields.apply(this._baseRepresentor.getTypes());
    }

    public void writeBinaries(BiConsumer<String, String> biConsumer) {
        Function<String, String> urlFunction = binaryId -> URLCreator.createBinaryURL(this._requestInfo.getServerURL(), binaryId, this._path);
        this.writeFields(BaseRepresentor::getBinaryFunctions, (key, binaryFile) -> biConsumer.accept((String)key, (String)urlFunction.apply((String)key)));
    }

    public void writeBooleanFields(BiConsumer<String, Boolean> biConsumer) {
        this.writeFields(BaseRepresentor::getBooleanFunctions, this.writeField(biConsumer));
    }

    public void writeBooleanListFields(BiConsumer<String, List<Boolean>> biConsumer) {
        this.writeFields(BaseRepresentor::getBooleanListFunctions, this.writeField(biConsumer));
    }

    public <U> BiConsumer<String, U> writeField(BiConsumer<String, U> biConsumer) {
        return this.writeField(Function.identity(), biConsumer);
    }

    public <U, V> BiConsumer<String, U> writeField(Function<U, V> function, BiConsumer<String, V> biConsumer) {
        return (key, u) -> {
            Object data = function.apply(u);
            if (data instanceof String) {
                if (data != null && !((String)data).isEmpty()) {
                    biConsumer.accept((String)key, (Object)data);
                }
            } else if (data != null) {
                biConsumer.accept((String)key, (Object)data);
            }
        };
    }

    public <U> void writeFields(Function<BaseRepresentor<T>, List<FieldFunction<T, U>>> representorFunction, BiConsumer<String, U> biConsumer) {
        List<FieldFunction<T, U>> list = representorFunction.apply(this._baseRepresentor);
        Stream stream = list.stream();
        stream.filter(fieldFunction -> {
            Predicate<String> fieldsPredicate = this.getFieldsPredicate();
            return fieldsPredicate.test(fieldFunction.getKey());
        }).forEach(fieldFunction -> {
            Object u = fieldFunction.apply(this._singleModel.getModel());
            biConsumer.accept(fieldFunction.getKey(), u);
        });
    }

    public void writeLinks(BiConsumer<String, String> biConsumer) {
        this.writeFields(BaseRepresentor::getLinkFunctions, this.writeField(Function.identity(), biConsumer));
    }

    public void writeLocalizedStringFields(BiConsumer<String, String> biConsumer) {
        this.writeFields(BaseRepresentor::getLocalizedStringFunctions, this.writeField(function -> (String)function.apply(this._requestInfo.getAcceptLanguage()), biConsumer));
    }

    public void writeNumberFields(BiConsumer<String, Number> biConsumer) {
        this.writeFields(BaseRepresentor::getNumberFunctions, this.writeField(biConsumer));
    }

    public void writeNumberListFields(BiConsumer<String, List<Number>> biConsumer) {
        this.writeFields(BaseRepresentor::getNumberListFunctions, this.writeField(biConsumer));
    }

    public <U extends Identifier> void writeRelatedCollection(RelatedCollection<U> relatedCollection, String resourceName, FunctionalList<String> parentEmbeddedPathElements, BiConsumer<String, FunctionalList<String>> biConsumer) {
        String key;
        Predicate<String> fieldsPredicate = this.getFieldsPredicate();
        if (!fieldsPredicate.test(key = relatedCollection.getKey())) {
            return;
        }
        String url = URLCreator.createNestedCollectionURL(this._requestInfo.getServerURL(), this._path, resourceName);
        FunctionalList<String> embeddedPathElements = new FunctionalList<String>(parentEmbeddedPathElements, key);
        biConsumer.accept(url, embeddedPathElements);
    }

    public void writeRelatedCollections(Function<String, Optional<String>> nameFunction, BiConsumer<String, FunctionalList<String>> biConsumer) {
        if (this._baseRepresentor.isNested()) {
            return;
        }
        Representor representor = (Representor)this._baseRepresentor;
        Stream stream = representor.getRelatedCollections();
        stream.forEach(relatedCollection -> {
            Class identifierClass = relatedCollection.getIdentifierClass();
            Optional optional = (Optional)nameFunction.apply(identifierClass.getName());
            optional.ifPresent(name -> this.writeRelatedCollection((RelatedCollection)relatedCollection, (String)name, this._embeddedPathElements, biConsumer));
        });
    }

    public <U> void writeRelatedModel(RelatedModel<T, U> relatedModel, Function<SingleModel<?>, Optional<Path>> pathFunction, BiConsumer<SingleModel<?>, FunctionalList<String>> modelBiConsumer, BiConsumer<String, FunctionalList<String>> linkedURLBiConsumer, BiConsumer<String, FunctionalList<String>> embeddedURLBiConsumer) {
        this.writeRelatedModel(relatedModel, pathFunction, (url, embeddedPathElements) -> {
            Optional singleModelOptional = FieldsWriter.getSingleModel(relatedModel, this._singleModel, (SingleModelFunction)Unsafe.unsafeCast(this._singleModelFunction));
            if (!singleModelOptional.isPresent()) {
                return;
            }
            Embedded embedded = this._requestInfo.getEmbedded();
            SingleModel singleModel = singleModelOptional.get();
            Stream stream = Stream.concat(Stream.of(embeddedPathElements.head()), embeddedPathElements.tailStream());
            String embeddedPath = String.join((CharSequence)".", stream.collect(Collectors.toList()));
            if (embedded.test(embeddedPath)) {
                embeddedURLBiConsumer.accept((String)url, (FunctionalList<String>)embeddedPathElements);
                modelBiConsumer.accept(singleModel, (FunctionalList<String>)embeddedPathElements);
            } else {
                linkedURLBiConsumer.accept((String)url, (FunctionalList<String>)embeddedPathElements);
            }
        });
    }

    public <U> void writeRelatedModel(RelatedModel<T, U> relatedModel, Function<SingleModel<?>, Optional<Path>> pathFunction, BiConsumer<String, FunctionalList<String>> biConsumer) {
        String key;
        Predicate<String> fieldsPredicate = this.getFieldsPredicate();
        if (!fieldsPredicate.test(key = relatedModel.getKey())) {
            return;
        }
        Optional<SingleModel<Path>> optional = FieldsWriter.getSingleModel(relatedModel, this._singleModel, (SingleModelFunction)Unsafe.unsafeCast(this._singleModelFunction));
        FunctionalList<String> embeddedPathElements = new FunctionalList<String>(this._embeddedPathElements, key);
        optional.flatMap(pathFunction).map(path -> URLCreator.createSingleURL(this._requestInfo.getServerURL(), path)).ifPresent(url -> biConsumer.accept((String)url, embeddedPathElements));
    }

    public void writeRelatedModels(Function<SingleModel<?>, Optional<Path>> pathFunction, BiConsumer<SingleModel<?>, FunctionalList<String>> modelBiConsumer, BiConsumer<String, FunctionalList<String>> linkedURLBiConsumer, BiConsumer<String, FunctionalList<String>> embeddedURLBiConsumer) {
        List embeddedRelatedModels = this._baseRepresentor.getRelatedModels();
        embeddedRelatedModels.forEach(relatedModel -> this.writeRelatedModel((RelatedModel)relatedModel, pathFunction, modelBiConsumer, linkedURLBiConsumer, embeddedURLBiConsumer));
    }

    public void writeRelativeURLFields(BiConsumer<String, String> biConsumer) {
        this.writeFields(BaseRepresentor::getRelativeURLFunctions, this.writeField(relativeURL -> URLCreator.createAbsoluteURL(this._requestInfo.getServerURL(), relativeURL), biConsumer));
    }

    public void writeSingleURL(Consumer<String> urlConsumer) {
        String url = URLCreator.createSingleURL(this._requestInfo.getServerURL(), this._path);
        urlConsumer.accept(url);
    }

    public void writeStringFields(BiConsumer<String, String> biConsumer) {
        this.writeFields(BaseRepresentor::getStringFunctions, this.writeField(biConsumer));
    }

    public void writeStringListFields(BiConsumer<String, List<String>> biConsumer) {
        this.writeFields(BaseRepresentor::getStringListFunctions, this.writeField(biConsumer));
    }

    public void writeTypes(Consumer<List<String>> consumer) {
        consumer.accept(this._baseRepresentor.getTypes());
    }
}

