/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.wiring.osgi.util;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.impl.internal.unsafe.Unsafe;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GenericUtil {
    public static <S> Try<Class<S>> getFirstGenericTypeArgumentFromTypeTry(Type type, Class<?> interfaceClass) {
        return GenericUtil.getGenericTypeArgumentFromTypeTry(type, interfaceClass, 0);
    }

    public static <S> Try<Class<S>> getGenericTypeArgumentFromTypeTry(Type type, Class<?> interfaceClass, int position) {
        return Try.success((Object)type).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(parameterizedType -> {
            Type rawType = parameterizedType.getRawType();
            String typeName = rawType.getTypeName();
            return typeName.equals(interfaceClass.getTypeName());
        }).map(ParameterizedType::getActualTypeArguments).filter(typeArguments -> ((Type[])typeArguments).length >= 1).map(typeArguments -> typeArguments[position]).map(typeArgument -> {
            if (typeArgument instanceof ParameterizedType) {
                return ((ParameterizedType)typeArgument).getRawType();
            }
            return typeArgument;
        }).map(Unsafe::unsafeCast);
    }

    public static <S> Try<Class<S>> getGenericTypeArgumentTry(Class<?> clazz, Class<?> interfaceClass, int position) {
        Type[] genericInterfaces = clazz.getGenericInterfaces();
        Try classTry = Try.fail((Exception)new IllegalArgumentException("Class " + clazz + " does not implement any interfaces"));
        for (Type genericInterface : genericInterfaces) {
            classTry = classTry.recoverWith(throwable -> GenericUtil.getGenericTypeArgumentFromTypeTry(genericInterface, interfaceClass, position));
        }
        return classTry.recoverWith(throwable -> GenericUtil.getGenericTypeArgumentTry(clazz.getSuperclass(), interfaceClass, position));
    }
}

