/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.wiring.osgi.resource;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.util.ManagerUtil;
import com.liferay.apio.architect.logger.ApioLogger;
import com.liferay.apio.architect.representor.Representable;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.router.ItemRouter;
import com.liferay.apio.architect.router.NestedCollectionRouter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.tracker.ServiceTracker;

@Component(immediate=true)
public class NestedCollectionResourceRegistrar {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private ApioLogger _apioLogger;
    private ServiceTracker<NestedCollectionResource, ServiceRegistration<?>> _serviceTracker;

    @Activate
    protected void activate(BundleContext bundleContext) {
        String[] classes = new String[]{ItemRouter.class.getName(), NestedCollectionRouter.class.getName(), Representable.class.getName()};
        this._serviceTracker = ManagerUtil.createServiceTracker(bundleContext, NestedCollectionResource.class, classes, (properties, service) -> {
            Try identifierClassTry = ManagerUtil.getTypeParamTry(service, NestedCollectionResource.class, 2);
            identifierClassTry.voidFold(__ -> this._warning("Unable to get identifier class from " + service.getClass()), clazz -> properties.put("apio.architect.principal.type.argument", clazz));
            Try parentClassTry = ManagerUtil.getTypeParamTry(service, NestedCollectionResource.class, 4);
            parentClassTry.voidFold(__ -> this._warning("Unable to get parent identifier class from " + service.getClass()), clazz -> properties.put("apio.architect.parent.identifier.class", clazz));
        });
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private void _warning(String message) {
        if (this._apioLogger != null) {
            this._apioLogger.warning(message);
        }
    }
}

