/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.wiring.osgi.manager.uri.mapper;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.impl.internal.unsafe.Unsafe;
import com.liferay.apio.architect.impl.internal.wiring.osgi.error.ApioDeveloperError;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.base.ClassNameBaseManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.representable.IdentifierClassManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.uri.mapper.PathIdentifierMapperManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.util.GenericUtil;
import com.liferay.apio.architect.uri.Path;
import com.liferay.apio.architect.uri.mapper.PathIdentifierMapper;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class PathIdentifierMapperManagerImpl
extends ClassNameBaseManager<PathIdentifierMapper>
implements PathIdentifierMapperManager {
    @Reference
    private IdentifierClassManager _identifierClassManager;

    public PathIdentifierMapperManagerImpl() {
        super(PathIdentifierMapper.class, 0);
    }

    @Override
    public boolean hasPathIdentifierMapper(String name) {
        return this._getPathIdentifierMapperTry(name).isSuccess();
    }

    @Override
    public <T> T mapToIdentifierOrFail(Path path) {
        Try<PathIdentifierMapper<T>> pathIdentifierMapperTry = this._getPathIdentifierMapperTry(path.getName());
        return (T)pathIdentifierMapperTry.map(service -> service.map(path)).orElseThrow(() -> new ApioDeveloperError.MustHavePathIdentifierMapper(path));
    }

    @Override
    public <T> Optional<Path> mapToPath(String name, T identifier) {
        Try<PathIdentifierMapper<T>> pathIdentifierMapperTry = this._getPathIdentifierMapperTry(name);
        return pathIdentifierMapperTry.map(service -> service.map(name, identifier)).toOptional();
    }

    private <T> Try<PathIdentifierMapper<T>> _getPathIdentifierMapperTry(String name) {
        return Try.success((Object)name).mapOptional(this._identifierClassManager::getIdentifierClassOptional).flatMap(clazz -> GenericUtil.getGenericTypeArgumentTry(clazz, Identifier.class, 0)).mapOptional(this::getServiceOptional).map(Unsafe::unsafeCast);
    }
}

