/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.wiring.osgi.manager.router;

import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.impl.internal.alias.ProvideFunction;
import com.liferay.apio.architect.impl.internal.routes.CollectionRoutesImpl;
import com.liferay.apio.architect.impl.internal.url.ServerURL;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.base.ClassNameBaseManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.cache.ManagerCache;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.provider.ProviderManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.representable.NameManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.router.CollectionRouterManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.router.ItemRouterManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.uri.mapper.PathIdentifierMapperManager;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.router.CollectionRouter;
import com.liferay.apio.architect.routes.CollectionRoutes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class CollectionRouterManagerImpl
extends ClassNameBaseManager<CollectionRouter>
implements CollectionRouterManager {
    private static final List<String> _mandatoryClassNames = Arrays.asList(Credentials.class.getName(), ServerURL.class.getName(), Pagination.class.getName());
    @Reference
    private ItemRouterManager _itemRouterManager;
    @Reference
    private NameManager _nameManager;
    @Reference
    private PathIdentifierMapperManager _pathIdentifierMapperManager;
    @Reference
    private ProviderManager _providerManager;

    public CollectionRouterManagerImpl() {
        super(CollectionRouter.class, 2);
    }

    @Override
    public Map<String, CollectionRoutes> getCollectionRoutes() {
        return ManagerCache.INSTANCE.getCollectionRoutes(this::_computeCollectionRoutes);
    }

    @Override
    public <T, S> Optional<CollectionRoutes<T, S>> getCollectionRoutesOptional(String name) {
        return ManagerCache.INSTANCE.getCollectionRoutesOptional(name, this::_computeCollectionRoutes);
    }

    @Override
    public List<String> getResourceNames() {
        return ManagerCache.INSTANCE.getRootResourceNames(this::_computeCollectionRoutes);
    }

    private void _computeCollectionRoutes() {
        List<String> missingMandatoryProviders = this._providerManager.getMissingProviders(_mandatoryClassNames);
        if (!missingMandatoryProviders.isEmpty()) {
            this.warning("Missing providers for mandatory classes: " + missingMandatoryProviders);
            return;
        }
        this.forEachService((className, collectionRouter) -> {
            Optional<String> nameOptional = this._nameManager.getNameOptional((String)className);
            if (!nameOptional.isPresent()) {
                this.warning("Unable to find a Representable for class name " + className);
                return;
            }
            String name = nameOptional.get();
            TreeSet<String> neededProviders = new TreeSet<String>();
            CollectionRoutesImpl.BuilderImpl builder = new CollectionRoutesImpl.BuilderImpl(name, ProvideFunction.curry(this._providerManager::provideMandatory), neededProviders::add, this._pathIdentifierMapperManager::mapToIdentifierOrFail);
            CollectionRoutes collectionRoutes = collectionRouter.collectionRoutes(builder);
            List<String> missingProviders = this._providerManager.getMissingProviders(neededProviders);
            if (!missingProviders.isEmpty()) {
                this.warning("Missing providers for classes: " + missingProviders);
                return;
            }
            Optional optional = this._itemRouterManager.getItemRoutesOptional(name);
            if (!optional.isPresent()) {
                this.warning("Missing item router for resource with name " + name);
                return;
            }
            ManagerCache.INSTANCE.putRootResourceName(name);
            ManagerCache.INSTANCE.putCollectionRoutes(name, collectionRoutes);
        });
    }
}

