/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.wiring.osgi.manager.representable;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.impl.internal.representor.RepresentorImpl;
import com.liferay.apio.architect.impl.internal.unsafe.Unsafe;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.base.BaseManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.cache.ManagerCache;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.representable.IdentifierClassManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.representable.NameManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.representable.RepresentableManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.util.ManagerUtil;
import com.liferay.apio.architect.related.RelatedCollection;
import com.liferay.apio.architect.representor.Representable;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;

@Component
public class RepresentableManagerImpl
extends BaseManager<Representable, Class<Identifier>>
implements NameManager,
IdentifierClassManager,
RepresentableManager {
    public RepresentableManagerImpl() {
        super(Representable.class);
    }

    @Override
    public <T extends Identifier> Optional<Class<T>> getIdentifierClassOptional(String name) {
        return ManagerCache.INSTANCE.getIdentifierClassOptional(name, this::_computeRepresentables);
    }

    @Override
    public Optional<String> getNameOptional(String className) {
        return ManagerCache.INSTANCE.getNameOptional(className, this::_computeRepresentables);
    }

    @Override
    public <T> Optional<Representor<T>> getRepresentorOptional(String name) {
        return ManagerCache.INSTANCE.getRepresentorOptional(name, this::_computeRepresentables);
    }

    @Override
    public Map<String, Representor> getRepresentors() {
        return ManagerCache.INSTANCE.getRepresentorMap(this::_computeRepresentables);
    }

    @Override
    protected void emit(ServiceReference<Representable> serviceReference, ServiceReferenceMapper.Emitter<Class<Identifier>> emitter) {
        Representable representable = (Representable)this.bundleContext.getService(serviceReference);
        if (representable == null) {
            return;
        }
        Try classTry = ManagerUtil.getGenericClassFromProperty(serviceReference, "apio.architect.principal.type.argument");
        classTry.recoverWith(__ -> ManagerUtil.getTypeParamTry(representable, Representable.class, 2)).map(Unsafe::unsafeCast).voidFold(__ -> this.warning("Unable to get identifier class from " + representable.getClass()), arg_0 -> emitter.emit(arg_0));
    }

    private void _computeRepresentables() {
        HashMap relatedCollections = new HashMap();
        this.forEachService((clazz, representable) -> {
            String name = representable.getName();
            Optional<Map<String, String>> optional = ManagerCache.INSTANCE.getNamesOptional();
            Optional<String> classNameOptional = optional.map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).filter(entry -> Objects.equals(entry.getValue(), name)).map(Map.Entry::getKey).findFirst();
            if (classNameOptional.isPresent()) {
                String className = classNameOptional.get();
                this.warning(this._getDuplicateErrorMessage((Class<Identifier>)clazz, name, className));
                return;
            }
            Representor representor = this._getRepresentor((Representable)Unsafe.unsafeCast(representable), (Class)Unsafe.unsafeCast(clazz), relatedCollections);
            ManagerCache.INSTANCE.putName(clazz.getName(), name);
            ManagerCache.INSTANCE.putIdentifierClass(name, (Class<Identifier>)clazz);
            ManagerCache.INSTANCE.putRepresentor(name, representor);
        });
    }

    private String _getDuplicateErrorMessage(Class<Identifier> clazz, String name, String className) {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("Representable registered under ").append(clazz.getName()).append(" has name ").append(name).append(", but it's already in use by Representable registered under ").append(className).toString();
    }

    private <T, S, U extends Identifier<S>> Representor<T> _getRepresentor(Representable<T, S, U> representable, Class<U> clazz, Map<String, List<RelatedCollection<?>>> relatedCollections) {
        Supplier<List<RelatedCollection<?>>> relatedCollectionSupplier = () -> (List)relatedCollections.get(clazz.getName());
        BiConsumer<Class<?>, RelatedCollection<?>> biConsumer = (identifierClass, relatedCollection) -> {
            List list = relatedCollections.computeIfAbsent(identifierClass.getName(), __ -> new ArrayList());
            list.add(relatedCollection);
        };
        RepresentorImpl.BuilderImpl builder = new RepresentorImpl.BuilderImpl(clazz, biConsumer, relatedCollectionSupplier);
        return representable.representor(builder);
    }
}

