/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.wiring.osgi.manager.provider;

import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.impl.internal.unsafe.Unsafe;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.base.ClassNameBaseManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.provider.ProviderManager;
import com.liferay.apio.architect.provider.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotFoundException;
import org.osgi.service.component.annotations.Component;

@Component
public class ProviderManagerImpl
extends ClassNameBaseManager<Provider>
implements ProviderManager {
    public ProviderManagerImpl() {
        super(Provider.class, 0);
    }

    @Override
    public List<String> getMissingProviders(Collection<String> neededProviders) {
        Set providedClassNames = this.serviceTrackerMap.keySet();
        ArrayList<String> list = new ArrayList<String>(neededProviders);
        list.removeAll(providedClassNames);
        return list;
    }

    @Override
    public <T> T provideMandatory(HttpServletRequest httpServletRequest, Class<T> clazz) {
        Optional<T> optional = this.provideOptional(httpServletRequest, clazz);
        if (clazz.equals(Credentials.class) && !optional.isPresent()) {
            return (T)Unsafe.unsafeCast(() -> "");
        }
        return optional.orElseThrow(() -> {
            this.warning("Missing provider for mandatory class: " + clazz);
            return new NotFoundException();
        });
    }

    @Override
    public <T> Optional<T> provideOptional(HttpServletRequest httpServletRequest, Class<T> clazz) {
        Optional optional = (Optional)Unsafe.unsafeCast(this.getServiceOptional(clazz));
        return optional.map(provider -> provider.createContext(httpServletRequest));
    }
}

