/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.wiring.osgi.manager.base;

import com.liferay.apio.architect.impl.internal.message.json.MessageMapper;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.base.BaseManager;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import java.util.function.BiConsumer;
import javax.ws.rs.core.MediaType;
import org.osgi.framework.ServiceReference;

public abstract class MessageMapperBaseManager<T extends MessageMapper>
extends BaseManager<T, String> {
    private final BiConsumer<MediaType, T> _storeBiConsumer;

    public MessageMapperBaseManager(Class<T> managedClass, BiConsumer<MediaType, T> storeBiConsumer) {
        super(managedClass);
        this._storeBiConsumer = storeBiConsumer;
    }

    protected void computeMessageMappers() {
        this.forEachService((key, messageMapper) -> {
            try {
                MediaType mediaType = MediaType.valueOf((String)key);
                this._storeBiConsumer.accept(mediaType, (MediaType)messageMapper);
            }
            catch (IllegalArgumentException iae) {
                this.warning("Message mapper has invalid media type: " + key);
            }
        });
    }

    @Override
    protected void emit(ServiceReference<T> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
        MessageMapper t = (MessageMapper)this.bundleContext.getService(serviceReference);
        emitter.emit((Object)t.getMediaType());
    }
}

