/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.wiring.osgi.manager.base;

import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.cache.ManagerCache;
import com.liferay.apio.architect.impl.internal.wiring.osgi.tracker.map.listener.ClearCacheServiceTrackerMapListener;
import com.liferay.apio.architect.logger.ApioLogger;
import com.liferay.osgi.service.tracker.collections.internal.DefaultServiceTrackerCustomizer;
import com.liferay.osgi.service.tracker.collections.internal.map.ServiceTrackerMapImpl;
import com.liferay.osgi.service.tracker.collections.internal.map.SingleValueServiceTrackerBucketFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucketFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import java.util.Set;
import java.util.function.BiConsumer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class BaseManager<T, U> {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected ApioLogger apioLogger;
    protected BundleContext bundleContext;
    protected ServiceTrackerMap<U, T> serviceTrackerMap;
    private final Class<T> _managedClass;

    public BaseManager(Class<T> managedClass) {
        this._managedClass = managedClass;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.serviceTrackerMap = new ServiceTrackerMapImpl(bundleContext, this._managedClass, null, this::emit, (ServiceTrackerCustomizer)new DefaultServiceTrackerCustomizer(bundleContext), (ServiceTrackerBucketFactory)new SingleValueServiceTrackerBucketFactory(), new ClearCacheServiceTrackerMapListener());
        ManagerCache.INSTANCE.clear();
    }

    @Deactivate
    public void deactivate() {
        this.serviceTrackerMap.close();
        ManagerCache.INSTANCE.clear();
    }

    public void forEachService(BiConsumer<U, T> biConsumer) {
        Set keys = this.serviceTrackerMap.keySet();
        keys.forEach(u -> biConsumer.accept(u, this.serviceTrackerMap.getService(u)));
    }

    protected abstract void emit(ServiceReference<T> var1, ServiceReferenceMapper.Emitter<U> var2);

    protected void warning(String message) {
        if (this.apioLogger != null) {
            this.apioLogger.warning(message);
        }
    }
}

