/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.url;

import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.impl.internal.pagination.PageType;
import com.liferay.apio.architect.impl.internal.url.ServerURL;
import com.liferay.apio.architect.pagination.Page;
import com.liferay.apio.architect.uri.Path;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public final class URLCreator {
    public static String createAbsoluteURL(ServerURL serverURL, String relativeURL) {
        if (relativeURL == null || relativeURL.isEmpty()) {
            return null;
        }
        URI uri = UriBuilder.fromUri((String)serverURL.get()).path(relativeURL).build(new Object[0]);
        return uri.toString();
    }

    public static String createBinaryURL(ServerURL serverURL, String binaryId, Path path) {
        return String.join((CharSequence)"/", serverURL.get(), "b", path.asURI(), binaryId);
    }

    public static String createCollectionPageURL(String collectionURL, Page page, PageType pageType) {
        return UriBuilder.fromUri((String)collectionURL).queryParam("page", new Object[]{pageType.getPageNumber(page)}).queryParam("per_page", new Object[]{page.getItemsPerPage()}).build(new Object[0]).toString();
    }

    public static String createCollectionURL(ServerURL serverURL, String name) {
        return serverURL.get() + "/p/" + name;
    }

    public static String createFormURL(ServerURL serverURL, Form form) {
        return String.join((CharSequence)"/", serverURL.get(), "f", form.getId());
    }

    public static String createNestedCollectionURL(ServerURL serverURL, Path path, String name) {
        return String.join((CharSequence)"/", serverURL.get(), "p", path.asURI(), name);
    }

    public static String createSingleURL(ServerURL serverURL, Path path) {
        return serverURL.get() + "/p/" + path.asURI();
    }

    public static Path getPath(String url) {
        String[] serverAndPath = url.split("/[bfp]/");
        if (serverAndPath.length == 2) {
            String fullPath = serverAndPath[1];
            String[] pathComponents = fullPath.split("/");
            String id = pathComponents.length == 1 ? null : pathComponents[1];
            return new Path(pathComponents[0], id);
        }
        return null;
    }

    private URLCreator() {
        throw new UnsupportedOperationException();
    }
}

