/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.routes;

import com.liferay.apio.architect.alias.IdentifierFunction;
import com.liferay.apio.architect.alias.form.FormBuilderFunction;
import com.liferay.apio.architect.alias.routes.DeleteItemConsumer;
import com.liferay.apio.architect.alias.routes.GetItemFunction;
import com.liferay.apio.architect.alias.routes.UpdateItemFunction;
import com.liferay.apio.architect.alias.routes.permission.HasRemovePermissionFunction;
import com.liferay.apio.architect.alias.routes.permission.HasUpdatePermissionFunction;
import com.liferay.apio.architect.consumer.throwable.ThrowableBiConsumer;
import com.liferay.apio.architect.consumer.throwable.ThrowableConsumer;
import com.liferay.apio.architect.consumer.throwable.ThrowablePentaConsumer;
import com.liferay.apio.architect.consumer.throwable.ThrowableTetraConsumer;
import com.liferay.apio.architect.consumer.throwable.ThrowableTriConsumer;
import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.function.throwable.ThrowableBiFunction;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.function.throwable.ThrowableHexaFunction;
import com.liferay.apio.architect.function.throwable.ThrowablePentaFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTetraFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTriFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.impl.internal.alias.ProvideFunction;
import com.liferay.apio.architect.impl.internal.form.FormImpl;
import com.liferay.apio.architect.impl.internal.operation.OperationImpl;
import com.liferay.apio.architect.impl.internal.routes.RoutesBuilderUtil;
import com.liferay.apio.architect.impl.internal.single.model.SingleModelImpl;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.uri.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class ItemRoutesImpl<T, S>
implements ItemRoutes<T, S> {
    private final DeleteItemConsumer<S> _deleteItemConsumer;
    private final Form _form;
    private final GetItemFunction<T, S> _singleModelFunction;
    private final UpdateItemFunction<T, S> _updateItemFunction;

    public ItemRoutesImpl(BuilderImpl<T, S> builderImpl) {
        this._deleteItemConsumer = ((BuilderImpl)builderImpl)._deleteItemConsumer;
        this._form = ((BuilderImpl)builderImpl)._form;
        this._singleModelFunction = ((BuilderImpl)builderImpl)._singleModelFunction;
        this._updateItemFunction = ((BuilderImpl)builderImpl)._updateItemFunction;
    }

    public Optional<DeleteItemConsumer<S>> getDeleteConsumerOptional() {
        return Optional.ofNullable(this._deleteItemConsumer);
    }

    public Optional<Form> getFormOptional() {
        return Optional.ofNullable(this._form);
    }

    public Optional<GetItemFunction<T, S>> getItemFunctionOptional() {
        return Optional.ofNullable(this._singleModelFunction);
    }

    public Optional<UpdateItemFunction<T, S>> getUpdateItemFunctionOptional() {
        return Optional.ofNullable(this._updateItemFunction);
    }

    public static class BuilderImpl<T, S>
    implements ItemRoutes.Builder<T, S> {
        private DeleteItemConsumer<S> _deleteItemConsumer;
        private Form _form;
        private HasRemovePermissionFunction<S> _hasRemovePermissionFunction;
        private HasUpdatePermissionFunction<S> _hasUpdatePermissionFunction;
        private final IdentifierFunction<?> _identifierFunction;
        private final String _name;
        private final Consumer<String> _neededProviderConsumer;
        private final ProvideFunction _provideFunction;
        private GetItemFunction<T, S> _singleModelFunction;
        private UpdateItemFunction<T, S> _updateItemFunction;

        public BuilderImpl(String name, ProvideFunction provideFunction, Consumer<String> neededProviderConsumer, Function<Path, ?> identifierFunction) {
            this._name = name;
            this._provideFunction = provideFunction;
            this._neededProviderConsumer = neededProviderConsumer;
            this._identifierFunction = identifierFunction::apply;
        }

        public <A> ItemRoutes.Builder<T, S> addGetter(ThrowableBiFunction<S, A, T> throwableBiFunction, Class<A> aClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._singleModelFunction = httpServletRequest -> s -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, Credentials.class, (a, credentials) -> (SingleModelImpl)throwableBiFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, a));
            return this;
        }

        public ItemRoutes.Builder<T, S> addGetter(ThrowableFunction<S, T> throwableFunction) {
            this._singleModelFunction = httpServletRequest -> s -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Credentials.class, credentials -> (SingleModelImpl)throwableFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s));
            return this;
        }

        public <A, B, C, D> ItemRoutes.Builder<T, S> addGetter(ThrowablePentaFunction<S, A, B, C, D, T> throwablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._singleModelFunction = httpServletRequest -> s -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, Credentials.class, (a, b, c, d, credentials) -> (SingleModelImpl)throwablePentaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, a, b, c, d));
            return this;
        }

        public <A, B, C> ItemRoutes.Builder<T, S> addGetter(ThrowableTetraFunction<S, A, B, C, T> throwableTetraFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._singleModelFunction = httpServletRequest -> s -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, Credentials.class, (a, b, c, credentials) -> (SingleModelImpl)throwableTetraFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, a, b, c));
            return this;
        }

        public <A, B> ItemRoutes.Builder<T, S> addGetter(ThrowableTriFunction<S, A, B, T> throwableTriFunction, Class<A> aClass, Class<B> bClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._singleModelFunction = httpServletRequest -> s -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, Credentials.class, (a, b, credentials) -> (SingleModelImpl)throwableTriFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, a, b));
            return this;
        }

        public <A> ItemRoutes.Builder<T, S> addRemover(ThrowableBiConsumer<S, A> throwableBiConsumer, Class<A> aClass, HasRemovePermissionFunction<S> hasRemovePermissionFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._hasRemovePermissionFunction = hasRemovePermissionFunction;
            this._deleteItemConsumer = httpServletRequest -> s -> RoutesBuilderUtil.provideConsumer((Function)this._provideFunction.apply(httpServletRequest), aClass, a -> throwableBiConsumer.accept(s, a));
            return this;
        }

        public ItemRoutes.Builder<T, S> addRemover(ThrowableConsumer<S> throwableConsumer, HasRemovePermissionFunction<S> hasRemovePermissionFunction) {
            this._hasRemovePermissionFunction = hasRemovePermissionFunction;
            this._deleteItemConsumer = __ -> throwableConsumer;
            return this;
        }

        public <A, B, C, D> ItemRoutes.Builder<T, S> addRemover(ThrowablePentaConsumer<S, A, B, C, D> throwablePentaConsumer, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, HasRemovePermissionFunction<S> hasRemovePermissionFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._hasRemovePermissionFunction = hasRemovePermissionFunction;
            this._deleteItemConsumer = httpServletRequest -> s -> RoutesBuilderUtil.provideConsumer((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, (a, b, c, d) -> throwablePentaConsumer.accept(s, a, b, c, d));
            return this;
        }

        public <A, B, C> ItemRoutes.Builder<T, S> addRemover(ThrowableTetraConsumer<S, A, B, C> throwableTetraConsumer, Class<A> aClass, Class<B> bClass, Class<C> cClass, HasRemovePermissionFunction<S> hasRemovePermissionFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._hasRemovePermissionFunction = hasRemovePermissionFunction;
            this._deleteItemConsumer = httpServletRequest -> s -> RoutesBuilderUtil.provideConsumer((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, (a, b, c) -> throwableTetraConsumer.accept(s, a, b, c));
            return this;
        }

        public <A, B> ItemRoutes.Builder<T, S> addRemover(ThrowableTriConsumer<S, A, B> throwableTriConsumer, Class<A> aClass, Class<B> bClass, HasRemovePermissionFunction<S> hasRemovePermissionFunction) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._hasRemovePermissionFunction = hasRemovePermissionFunction;
            this._deleteItemConsumer = httpServletRequest -> s -> RoutesBuilderUtil.provideConsumer((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, (a, b) -> throwableTriConsumer.accept(s, a, b));
            return this;
        }

        public <R> ItemRoutes.Builder<T, S> addUpdater(ThrowableBiFunction<S, R, T> throwableBiFunction, HasUpdatePermissionFunction<S> hasUpdatePermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._hasUpdatePermissionFunction = hasUpdatePermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("u", this._name), (Function<Path, ?>)this._identifierFunction));
            this._updateItemFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Credentials.class, credentials -> (SingleModelImpl)throwableBiFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, form.get(body)));
            return this;
        }

        public <A, B, C, D, R> ItemRoutes.Builder<T, S> addUpdater(ThrowableHexaFunction<S, R, A, B, C, D, T> throwableHexaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, HasUpdatePermissionFunction<S> hasUpdatePermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._hasUpdatePermissionFunction = hasUpdatePermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("u", this._name), (Function<Path, ?>)this._identifierFunction));
            this._updateItemFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, Credentials.class, (a, b, c, d, credentials) -> (SingleModelImpl)throwableHexaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, form.get(body), a, b, c, d));
            return this;
        }

        public <A, B, C, R> ItemRoutes.Builder<T, S> addUpdater(ThrowablePentaFunction<S, R, A, B, C, T> throwablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, HasUpdatePermissionFunction<S> hasUpdatePermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._hasUpdatePermissionFunction = hasUpdatePermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("u", this._name), (Function<Path, ?>)this._identifierFunction));
            this._updateItemFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, Credentials.class, (a, b, c, credentials) -> (SingleModelImpl)throwablePentaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, form.get(body), a, b, c));
            return this;
        }

        public <A, B, R> ItemRoutes.Builder<T, S> addUpdater(ThrowableTetraFunction<S, R, A, B, T> throwableTetraFunction, Class<A> aClass, Class<B> bClass, HasUpdatePermissionFunction<S> hasUpdatePermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._hasUpdatePermissionFunction = hasUpdatePermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("u", this._name), (Function<Path, ?>)this._identifierFunction));
            this._updateItemFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, Credentials.class, (a, b, credentials) -> (SingleModelImpl)throwableTetraFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, form.get(body), a, b));
            return this;
        }

        public <A, R> ItemRoutes.Builder<T, S> addUpdater(ThrowableTriFunction<S, R, A, T> throwableTriFunction, Class<A> aClass, HasUpdatePermissionFunction<S> hasUpdatePermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._hasUpdatePermissionFunction = hasUpdatePermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("u", this._name), (Function<Path, ?>)this._identifierFunction));
            this._updateItemFunction = httpServletRequest -> s -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, Credentials.class, (a, credentials) -> (SingleModelImpl)throwableTriFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, this._getOperations((Credentials)credentials, (S)s))).apply(s, form.get(body), a));
            return this;
        }

        public ItemRoutes<T, S> build() {
            return new ItemRoutesImpl(this);
        }

        private List<Operation> _getOperations(Credentials credentials, S identifier) {
            ArrayList<Operation> operations = new ArrayList<Operation>();
            Optional.ofNullable(this._hasRemovePermissionFunction).filter(function -> (Boolean)Try.fromFallible(() -> (Boolean)function.apply((Object)credentials, identifier)).orElse((Object)false)).ifPresent(__ -> operations.add(new OperationImpl(HTTPMethod.DELETE, this._name + "/delete")));
            Optional.ofNullable(this._hasUpdatePermissionFunction).filter(function -> (Boolean)Try.fromFallible(() -> (Boolean)function.apply((Object)credentials, identifier)).orElse((Object)false)).ifPresent(__ -> operations.add(new OperationImpl(this._form, HTTPMethod.PUT, this._name + "/update")));
            return operations;
        }
    }
}

