/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.routes;

import com.liferay.apio.architect.alias.IdentifierFunction;
import com.liferay.apio.architect.alias.form.FormBuilderFunction;
import com.liferay.apio.architect.alias.routes.CreateItemFunction;
import com.liferay.apio.architect.alias.routes.GetPageFunction;
import com.liferay.apio.architect.alias.routes.permission.HasAddingPermissionFunction;
import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.function.throwable.ThrowableBiFunction;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.function.throwable.ThrowablePentaFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTetraFunction;
import com.liferay.apio.architect.function.throwable.ThrowableTriFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.impl.internal.alias.ProvideFunction;
import com.liferay.apio.architect.impl.internal.form.FormImpl;
import com.liferay.apio.architect.impl.internal.operation.OperationImpl;
import com.liferay.apio.architect.impl.internal.pagination.PageImpl;
import com.liferay.apio.architect.impl.internal.routes.RoutesBuilderUtil;
import com.liferay.apio.architect.impl.internal.single.model.SingleModelImpl;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.uri.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class CollectionRoutesImpl<T, S>
implements CollectionRoutes<T, S> {
    private final CreateItemFunction<T> _createItemFunction;
    private final Form _form;
    private final GetPageFunction<T> _getPageFunction;

    public CollectionRoutesImpl(BuilderImpl<T, S> builderImpl) {
        this._createItemFunction = ((BuilderImpl)builderImpl)._createItemFunction;
        this._form = ((BuilderImpl)builderImpl)._form;
        this._getPageFunction = ((BuilderImpl)builderImpl)._getPageFunction;
    }

    public Optional<CreateItemFunction<T>> getCreateItemFunctionOptional() {
        return Optional.ofNullable(this._createItemFunction);
    }

    public Optional<Form> getFormOptional() {
        return Optional.ofNullable(this._form);
    }

    public Optional<GetPageFunction<T>> getGetPageFunctionOptional() {
        return Optional.ofNullable(this._getPageFunction);
    }

    public static class BuilderImpl<T, S>
    implements CollectionRoutes.Builder<T, S> {
        private CreateItemFunction<T> _createItemFunction;
        private Form _form;
        private GetPageFunction<T> _getPageFunction;
        private HasAddingPermissionFunction _hasAddingPermissionFunction;
        private final IdentifierFunction<?> _identifierFunction;
        private final String _name;
        private final Consumer<String> _neededProviderConsumer;
        private final ProvideFunction _provideFunction;

        public BuilderImpl(String name, ProvideFunction provideFunction, Consumer<String> neededProviderConsumer, Function<Path, ?> identifierFunction) {
            this._name = name;
            this._provideFunction = provideFunction;
            this._neededProviderConsumer = neededProviderConsumer;
            this._identifierFunction = identifierFunction::apply;
        }

        public <A, R> CollectionRoutes.Builder<T, S> addCreator(ThrowableBiFunction<R, A, T> throwableBiFunction, Class<A> aClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._hasAddingPermissionFunction = hasAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name), (Function<Path, ?>)this._identifierFunction));
            this._createItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, a -> (SingleModelImpl)throwableBiFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, Collections.emptyList())).apply(form.get(body), a));
            return this;
        }

        public <R> CollectionRoutes.Builder<T, S> addCreator(ThrowableFunction<R, T> throwableFunction, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._hasAddingPermissionFunction = hasAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name), (Function<Path, ?>)this._identifierFunction));
            this._createItemFunction = httpServletRequest -> body -> Try.fromFallible(() -> (SingleModelImpl)throwableFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, Collections.emptyList())).apply(form.get(body)));
            return this;
        }

        public <A, B, C, D, R> CollectionRoutes.Builder<T, S> addCreator(ThrowablePentaFunction<R, A, B, C, D, T> throwablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._hasAddingPermissionFunction = hasAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name), (Function<Path, ?>)this._identifierFunction));
            this._createItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, dClass, (a, b, c, d) -> (SingleModelImpl)throwablePentaFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, Collections.emptyList())).apply(form.get(body), a, b, c, d));
            return this;
        }

        public <A, B, C, R> CollectionRoutes.Builder<T, S> addCreator(ThrowableTetraFunction<R, A, B, C, T> throwableTetraFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._hasAddingPermissionFunction = hasAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name), (Function<Path, ?>)this._identifierFunction));
            this._createItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, cClass, (a, b, c) -> (SingleModelImpl)throwableTetraFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, Collections.emptyList())).apply(form.get(body), a, b, c));
            return this;
        }

        public <A, B, R> CollectionRoutes.Builder<T, S> addCreator(ThrowableTriFunction<R, A, B, T> throwableTriFunction, Class<A> aClass, Class<B> bClass, HasAddingPermissionFunction hasAddingPermissionFunction, FormBuilderFunction<R> formBuilderFunction) {
            Form form;
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._hasAddingPermissionFunction = hasAddingPermissionFunction;
            this._form = form = (Form)formBuilderFunction.apply(new FormImpl.BuilderImpl(Arrays.asList("c", this._name), (Function<Path, ?>)this._identifierFunction));
            this._createItemFunction = httpServletRequest -> body -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), aClass, bClass, (a, b) -> (SingleModelImpl)throwableTriFunction.andThen(t -> new SingleModelImpl<Object>(t, this._name, Collections.emptyList())).apply(form.get(body), a, b));
            return this;
        }

        public <A> CollectionRoutes.Builder<T, S> addGetter(ThrowableBiFunction<Pagination, A, PageItems<T>> throwableBiFunction, Class<A> aClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._getPageFunction = httpServletRequest -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, Credentials.class, (pagination, a, credentials) -> (PageImpl)throwableBiFunction.andThen(items -> new PageImpl(this._name, items, (Pagination)pagination, this._getOperations((Credentials)credentials))).apply(pagination, a));
            return this;
        }

        public CollectionRoutes.Builder<T, S> addGetter(ThrowableFunction<Pagination, PageItems<T>> throwableFunction) {
            this._getPageFunction = httpServletRequest -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, Credentials.class, (pagination, credentials) -> (PageImpl)throwableFunction.andThen(items -> new PageImpl(this._name, items, (Pagination)pagination, this._getOperations((Credentials)credentials))).apply(pagination));
            return this;
        }

        public <A, B, C, D> CollectionRoutes.Builder<T, S> addGetter(ThrowablePentaFunction<Pagination, A, B, C, D, PageItems<T>> throwablePentaFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass, Class<D> dClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._neededProviderConsumer.accept(dClass.getName());
            this._getPageFunction = httpServletRequest -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, cClass, dClass, Credentials.class, (pagination, a, b, c, d, credentials) -> (PageImpl)throwablePentaFunction.andThen(items -> new PageImpl(this._name, items, (Pagination)pagination, this._getOperations((Credentials)credentials))).apply(pagination, a, b, c, d));
            return this;
        }

        public <A, B, C> CollectionRoutes.Builder<T, S> addGetter(ThrowableTetraFunction<Pagination, A, B, C, PageItems<T>> throwableTetraFunction, Class<A> aClass, Class<B> bClass, Class<C> cClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._neededProviderConsumer.accept(cClass.getName());
            this._getPageFunction = httpServletRequest -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, cClass, Credentials.class, (pagination, a, b, c, credentials) -> (PageImpl)throwableTetraFunction.andThen(items -> new PageImpl(this._name, items, (Pagination)pagination, this._getOperations((Credentials)credentials))).apply(pagination, a, b, c));
            return this;
        }

        public <A, B> CollectionRoutes.Builder<T, S> addGetter(ThrowableTriFunction<Pagination, A, B, PageItems<T>> throwableTriFunction, Class<A> aClass, Class<B> bClass) {
            this._neededProviderConsumer.accept(aClass.getName());
            this._neededProviderConsumer.accept(bClass.getName());
            this._getPageFunction = httpServletRequest -> RoutesBuilderUtil.provide((Function)this._provideFunction.apply(httpServletRequest), Pagination.class, aClass, bClass, Credentials.class, (pagination, a, b, credentials) -> (PageImpl)throwableTriFunction.andThen(items -> new PageImpl(this._name, items, (Pagination)pagination, this._getOperations((Credentials)credentials))).apply(pagination, a, b));
            return this;
        }

        public CollectionRoutes<T, S> build() {
            return new CollectionRoutesImpl(this);
        }

        private List<Operation> _getOperations(Credentials credentials) {
            return Optional.ofNullable(this._form).filter(__ -> (Boolean)Try.fromFallible(() -> (Boolean)this._hasAddingPermissionFunction.apply((Object)credentials)).orElse((Object)false)).map(form -> new OperationImpl((Form)form, HTTPMethod.POST, this._name + "/create")).map(Operation.class::cast).map(Collections::singletonList).orElseGet(Collections::emptyList);
        }
    }
}

