/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.representor;

import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.impl.internal.related.RelatedCollectionImpl;
import com.liferay.apio.architect.impl.internal.representor.BaseRepresentorImpl;
import com.liferay.apio.architect.related.RelatedCollection;
import com.liferay.apio.architect.representor.Representor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class RepresentorImpl<T>
extends BaseRepresentorImpl<T>
implements Representor<T> {
    private Function<T, ?> _identifierFunction;
    private final List<RelatedCollection<?>> _relatedCollections;
    private final Supplier<List<RelatedCollection<?>>> _supplier;

    public Object getIdentifier(T model) {
        return this._identifierFunction.apply(model);
    }

    public Stream<RelatedCollection<? extends Identifier>> getRelatedCollections() {
        return Stream.of(this._relatedCollections, this._supplier.get()).filter(Objects::nonNull).flatMap(Collection::stream);
    }

    public boolean isNested() {
        return false;
    }

    private RepresentorImpl(Supplier<List<RelatedCollection<?>>> supplier) {
        this._supplier = supplier;
        this._relatedCollections = new ArrayList();
    }

    private <S extends Identifier> void _addRelatedCollection(String key, Class<S> itemIdentifierClass) {
        RelatedCollectionImpl<S> relatedCollection = new RelatedCollectionImpl<S>(key, itemIdentifierClass);
        this._relatedCollections.add(relatedCollection);
    }

    private void _setIdentifierFunction(Function<T, ?> identifierFunction) {
        this._identifierFunction = identifierFunction;
    }

    public static class BuilderImpl<T, S>
    extends BaseRepresentorImpl.BaseBuilderImpl<T, RepresentorImpl<T>>
    implements Representor.Builder<T, S> {
        private final BiConsumer<Class<?>, RelatedCollection<?>> _biConsumer;
        private final Class<? extends Identifier> _identifierClass;

        public BuilderImpl(Class<? extends Identifier<S>> identifierClass) {
            this(identifierClass, (clazz, relatedCollection) -> {}, Collections::emptyList);
        }

        public BuilderImpl(Class<? extends Identifier<S>> identifierClass, BiConsumer<Class<?>, RelatedCollection<?>> biConsumer, Supplier<List<RelatedCollection<?>>> supplier) {
            super(new RepresentorImpl(supplier));
            this._identifierClass = identifierClass;
            this._biConsumer = biConsumer;
        }

        public IdentifierStepImpl types(String type, String ... types) {
            ((RepresentorImpl)this.baseRepresentor).addTypes(type, types);
            return new IdentifierStepImpl();
        }

        public class IdentifierStepImpl
        implements Representor.IdentifierStep<T, S> {
            public Representor.FirstStep<T> identifier(Function<T, S> identifierFunction) {
                ((RepresentorImpl)BuilderImpl.this.baseRepresentor)._setIdentifierFunction(identifierFunction);
                return new FirstStepImpl();
            }

            private IdentifierStepImpl() {
            }
        }

        public class FirstStepImpl
        extends BaseRepresentorImpl.BaseBuilderImpl.BaseFirstStepImpl<Representor<T>, Representor.FirstStep<T>>
        implements Representor.FirstStep<T> {
            public <U> Representor.FirstStep<T> addBidirectionalModel(String key, String relatedKey, Class<? extends Identifier<U>> identifierClass, Function<T, U> identifierFunction) {
                RelatedCollectionImpl relatedCollection = new RelatedCollectionImpl(relatedKey, BuilderImpl.this._identifierClass);
                BuilderImpl.this._biConsumer.accept(identifierClass, relatedCollection);
                ((RepresentorImpl)BuilderImpl.this.baseRepresentor).addRelatedModel(key, identifierClass, identifierFunction);
                return this;
            }

            public <U extends Identifier> Representor.FirstStep<T> addRelatedCollection(String key, Class<U> itemIdentifierClass) {
                ((RepresentorImpl)BuilderImpl.this.baseRepresentor)._addRelatedCollection(key, itemIdentifierClass);
                return this;
            }

            @Override
            public FirstStepImpl getThis() {
                return this;
            }
        }
    }
}

