/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.provider;

import com.liferay.apio.architect.impl.internal.url.ServerURL;
import com.liferay.apio.architect.provider.Provider;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component
public class ServerURLProvider
implements Provider<ServerURL> {
    public ServerURL createContext(HttpServletRequest httpServletRequest) {
        return () -> {
            StringBuilder sb = new StringBuilder();
            String forwardedProto = httpServletRequest.getHeader("X-Forwarded-Proto");
            if (forwardedProto != null) {
                sb.append(forwardedProto);
            } else {
                sb.append(httpServletRequest.getScheme());
            }
            sb.append("://");
            String forwardedHost = httpServletRequest.getHeader("X-Forwarded-Host");
            if (forwardedHost == null) {
                sb.append(httpServletRequest.getServerName());
                sb.append(":");
                sb.append(httpServletRequest.getServerPort());
            } else {
                sb.append(forwardedHost);
            }
            sb.append(httpServletRequest.getContextPath());
            return sb.toString();
        };
    }
}

