/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.provider;

import com.liferay.apio.architect.impl.internal.response.control.Fields;
import com.liferay.apio.architect.provider.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;

@Component
public class FieldsProvider
implements Provider<Fields> {
    private static final String _REGEXP = "fields\\[([A-Z|a-z]+)]";
    private static final Function<String, String> _getTypeFunction = key -> key.substring(key.indexOf("[") + 1, key.indexOf("]"));

    public Fields createContext(HttpServletRequest httpServletRequest) {
        Map parameterMap = httpServletRequest.getParameterMap();
        Set set = parameterMap.entrySet();
        Stream stream = set.stream();
        Map<String, List> fieldsMap = stream.filter(entry -> {
            String key = (String)entry.getKey();
            return key.matches(_REGEXP);
        }).filter(entry -> {
            String[] value = (String[])entry.getValue();
            return value.length == 1;
        }).filter(entry -> !((String[])entry.getValue())[0].isEmpty()).collect(Collectors.toMap(entry -> _getTypeFunction.apply((String)entry.getKey()), entry -> Arrays.asList(((String[])entry.getValue())[0].split(","))));
        return types -> field -> {
            Stream typesStream = types.stream();
            List fields = typesStream.map(fieldsMap::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
            return fields.isEmpty() || fields.contains(field);
        };
    }
}

