/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.pagination;

import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.pagination.Page;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.uri.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class PageImpl<T>
implements Page<T> {
    private final Collection<T> _items;
    private final int _itemsPerPage;
    private final List<Operation> _operations;
    private final int _pageNumber;
    private final Path _path;
    private final String _resourceName;
    private final int _totalCount;

    public PageImpl(String resourceName, PageItems<T> pageItems, Pagination pagination, List<Operation> operations) {
        this(resourceName, pageItems, pagination, null, operations);
    }

    public PageImpl(String resourceName, PageItems<T> pageItems, Pagination pagination, Path path, List<Operation> operations) {
        this._resourceName = resourceName;
        this._items = pageItems.getItems();
        this._itemsPerPage = pagination.getItemsPerPage();
        this._pageNumber = pagination.getPageNumber();
        this._totalCount = pageItems.getTotalCount();
        this._path = path;
        this._operations = operations;
    }

    public Collection<T> getItems() {
        return this._items;
    }

    public int getItemsPerPage() {
        return this._itemsPerPage;
    }

    public int getLastPageNumber() {
        if (this._totalCount == 0) {
            return 1;
        }
        return -Math.floorDiv(-this._totalCount, this._itemsPerPage);
    }

    public List<Operation> getOperations() {
        return this._operations;
    }

    public int getPageNumber() {
        return this._pageNumber;
    }

    public Optional<Path> getPathOptional() {
        return Optional.ofNullable(this._path);
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public int getTotalCount() {
        return this._totalCount;
    }

    public boolean hasNext() {
        return this.getLastPageNumber() > this._pageNumber;
    }

    public boolean hasPrevious() {
        return this._pageNumber > 1;
    }
}

