/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.message.json.plain;

import com.liferay.apio.architect.impl.internal.list.FunctionalList;
import com.liferay.apio.architect.impl.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.impl.internal.message.json.SingleModelMessageMapper;
import java.util.List;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component
public class PlainJSONSingleModelMessageMapper<T>
implements SingleModelMessageMapper<T> {
    @Override
    public String getMediaType() {
        return "application/json";
    }

    @Override
    public void mapBooleanField(JSONObjectBuilder jsonObjectBuilder, String fieldName, Boolean value) {
        jsonObjectBuilder.field(fieldName).booleanValue(value);
    }

    @Override
    public void mapBooleanListField(JSONObjectBuilder jsonObjectBuilder, String fieldName, List<Boolean> value) {
        jsonObjectBuilder.field(fieldName).arrayValue().addAllBooleans(value);
    }

    @Override
    public void mapEmbeddedResourceBooleanField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, Boolean value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).booleanValue(value);
    }

    @Override
    public void mapEmbeddedResourceBooleanListField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, List<Boolean> value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).arrayValue().addAllBooleans(value);
    }

    @Override
    public void mapEmbeddedResourceLink(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, String url) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).stringValue(url);
    }

    @Override
    public void mapEmbeddedResourceNumberField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, Number value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).numberValue(value);
    }

    @Override
    public void mapEmbeddedResourceNumberListField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, List<Number> value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).arrayValue().addAllNumbers(value);
    }

    @Override
    public void mapEmbeddedResourceStringField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, String value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).stringValue(value);
    }

    @Override
    public void mapEmbeddedResourceStringListField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, List<String> value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).arrayValue().addAllStrings(value);
    }

    @Override
    public void mapEmbeddedResourceURL(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String url) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field("self").stringValue(url);
    }

    @Override
    public void mapLink(JSONObjectBuilder jsonObjectBuilder, String fieldName, String url) {
        jsonObjectBuilder.field(fieldName).stringValue(url);
    }

    @Override
    public void mapLinkedResourceURL(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String url) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).stringValue(url);
    }

    @Override
    public void mapNumberField(JSONObjectBuilder jsonObjectBuilder, String fieldName, Number value) {
        jsonObjectBuilder.field(fieldName).numberValue(value);
    }

    @Override
    public void mapNumberListField(JSONObjectBuilder jsonObjectBuilder, String fieldName, List<Number> value) {
        jsonObjectBuilder.field(fieldName).arrayValue().addAllNumbers(value);
    }

    @Override
    public void mapSelfURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.field("self").stringValue(url);
    }

    @Override
    public void mapStringField(JSONObjectBuilder jsonObjectBuilder, String fieldName, String value) {
        jsonObjectBuilder.field(fieldName).stringValue(value);
    }

    @Override
    public void mapStringListField(JSONObjectBuilder jsonObjectBuilder, String fieldName, List<String> value) {
        jsonObjectBuilder.field(fieldName).arrayValue().addAllStrings(value);
    }
}

