/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.message.json.plain;

import com.liferay.apio.architect.impl.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.impl.internal.message.json.PageMessageMapper;
import com.liferay.apio.architect.impl.internal.message.json.SingleModelMessageMapper;
import com.liferay.apio.architect.impl.internal.message.json.plain.PlainJSONSingleModelMessageMapper;
import com.liferay.apio.architect.single.model.SingleModel;
import java.util.Optional;
import javax.ws.rs.core.HttpHeaders;
import org.osgi.service.component.annotations.Component;

@Component
public class PlainJSONPageMessageMapper<T>
implements PageMessageMapper<T> {
    private final SingleModelMessageMapper<T> _singleModelMessageMapper = new PlainJSONSingleModelMessageMapper();

    @Override
    public String getMediaType() {
        return "application/json";
    }

    @Override
    public Optional<SingleModelMessageMapper<T>> getSingleModelMessageMapperOptional() {
        return Optional.of(this._singleModelMessageMapper);
    }

    @Override
    public void mapCollectionURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.field("collection").stringValue(url);
    }

    @Override
    public void mapCurrentPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        this._singleModelMessageMapper.mapSelfURL(jsonObjectBuilder, url);
    }

    @Override
    public void mapFirstPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("pages", "first").stringValue(url);
    }

    @Override
    public void mapItemTotalCount(JSONObjectBuilder jsonObjectBuilder, int totalCount) {
        jsonObjectBuilder.field("totalNumberOfItems").numberValue(totalCount);
    }

    @Override
    public void mapLastPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("pages", "last").stringValue(url);
    }

    @Override
    public void mapNextPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("pages", "next").stringValue(url);
    }

    @Override
    public void mapPageCount(JSONObjectBuilder jsonObjectBuilder, int count) {
        jsonObjectBuilder.field("numberOfItems").numberValue(count);
    }

    @Override
    public void mapPreviousPageURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.nestedField("pages", "prev").stringValue(url);
    }

    @Override
    public void onFinishItem(JSONObjectBuilder pageJSONObjectBuilder, JSONObjectBuilder itemJSONObjectBuilder, SingleModel<T> singleModel, HttpHeaders httpHeaders) {
        pageJSONObjectBuilder.field("elements").arrayValue().add(itemJSONObjectBuilder);
    }
}

