/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.message.json.ld;

import com.liferay.apio.architect.impl.internal.list.FunctionalList;
import com.liferay.apio.architect.impl.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.impl.internal.message.json.SingleModelMessageMapper;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.operation.Operation;
import com.liferay.apio.architect.single.model.SingleModel;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.HttpHeaders;
import org.osgi.service.component.annotations.Component;

@Component
public class JSONLDSingleModelMessageMapper<T>
implements SingleModelMessageMapper<T> {
    @Override
    public String getMediaType() {
        return "application/ld+json";
    }

    @Override
    public void mapBooleanField(JSONObjectBuilder jsonObjectBuilder, String fieldName, Boolean value) {
        jsonObjectBuilder.field(fieldName).booleanValue(value);
    }

    @Override
    public void mapBooleanListField(JSONObjectBuilder jsonObjectBuilder, String fieldName, List<Boolean> value) {
        jsonObjectBuilder.field(fieldName).arrayValue().addAllBooleans(value);
    }

    @Override
    public void mapEmbeddedOperationFormURL(JSONObjectBuilder singleModelJSONObjectBuilder, JSONObjectBuilder operationJSONObjectBuilder, FunctionalList<String> embeddedPathElements, String url) {
        operationJSONObjectBuilder.field("expects").stringValue(url);
    }

    @Override
    public void mapEmbeddedOperationMethod(JSONObjectBuilder singleModelJSONObjectBuilder, JSONObjectBuilder operationJSONObjectBuilder, FunctionalList<String> embeddedPathElements, HTTPMethod httpMethod) {
        operationJSONObjectBuilder.field("method").stringValue(httpMethod.name());
    }

    @Override
    public void mapEmbeddedResourceBooleanField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, Boolean value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).booleanValue(value);
    }

    @Override
    public void mapEmbeddedResourceBooleanListField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, List<Boolean> value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).arrayValue().addAllBooleans(value);
    }

    @Override
    public void mapEmbeddedResourceLink(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, String url) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).stringValue(url);
    }

    @Override
    public void mapEmbeddedResourceNumberField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, Number value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).numberValue(value);
    }

    @Override
    public void mapEmbeddedResourceNumberListField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, List<Number> value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).arrayValue().addAllNumbers(value);
    }

    @Override
    public void mapEmbeddedResourceStringField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, String value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).stringValue(value);
    }

    @Override
    public void mapEmbeddedResourceStringListField(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String fieldName, List<String> value) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field(fieldName).arrayValue().addAllStrings(value);
    }

    @Override
    public void mapEmbeddedResourceTypes(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, List<String> types) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field("@type").arrayValue().addAllStrings(types);
    }

    @Override
    public void mapEmbeddedResourceURL(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String url) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        jsonObjectBuilder.nestedField(embeddedPathElements.head(), (String[])tailStream.toArray(String[]::new)).field("@id").stringValue(url);
    }

    @Override
    public void mapLink(JSONObjectBuilder jsonObjectBuilder, String fieldName, String url) {
        jsonObjectBuilder.field(fieldName).stringValue(url);
    }

    @Override
    public void mapLinkedResourceURL(JSONObjectBuilder jsonObjectBuilder, FunctionalList<String> embeddedPathElements, String url) {
        String head = embeddedPathElements.head();
        Stream<String> tailStream = embeddedPathElements.tailStream();
        String[] tail = (String[])tailStream.toArray(String[]::new);
        jsonObjectBuilder.nestedField(head, tail).stringValue(url);
        Stream<String> middleStream = embeddedPathElements.middleStream();
        String[] middle = (String[])middleStream.toArray(String[]::new);
        Optional<String> optional = embeddedPathElements.lastOptional();
        if (optional.isPresent()) {
            jsonObjectBuilder.nestedField(head, middle).field("@context").arrayValue().add(builder -> builder.field((String)optional.get()).field("@type").stringValue("@id"));
        } else {
            jsonObjectBuilder.field("@context").arrayValue().add(builder -> builder.field(head).field("@type").stringValue("@id"));
        }
    }

    @Override
    public void mapNumberField(JSONObjectBuilder jsonObjectBuilder, String fieldName, Number value) {
        jsonObjectBuilder.field(fieldName).numberValue(value);
    }

    @Override
    public void mapNumberListField(JSONObjectBuilder jsonObjectBuilder, String fieldName, List<Number> value) {
        jsonObjectBuilder.field(fieldName).arrayValue().addAllNumbers(value);
    }

    @Override
    public void mapOperationFormURL(JSONObjectBuilder singleModelJSONObjectBuilder, JSONObjectBuilder operationJSONObjectBuilder, String url) {
        operationJSONObjectBuilder.field("expects").stringValue(url);
    }

    @Override
    public void mapOperationMethod(JSONObjectBuilder singleModelJSONObjectBuilder, JSONObjectBuilder operationJSONObjectBuilder, HTTPMethod httpMethod) {
        operationJSONObjectBuilder.field("method").stringValue(httpMethod.name());
    }

    @Override
    public void mapSelfURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.field("@id").stringValue(url);
    }

    @Override
    public void mapStringField(JSONObjectBuilder jsonObjectBuilder, String fieldName, String value) {
        jsonObjectBuilder.field(fieldName).stringValue(value);
    }

    @Override
    public void mapStringListField(JSONObjectBuilder jsonObjectBuilder, String fieldName, List<String> value) {
        jsonObjectBuilder.field(fieldName).arrayValue().addAllStrings(value);
    }

    @Override
    public void mapTypes(JSONObjectBuilder jsonObjectBuilder, List<String> types) {
        jsonObjectBuilder.field("@type").arrayValue().addAllStrings(types);
    }

    @Override
    public void onFinish(JSONObjectBuilder jsonObjectBuilder, SingleModel<T> singleModel, HttpHeaders httpHeaders) {
        jsonObjectBuilder.field("@context").arrayValue(arrayBuilder -> arrayBuilder.add(builder -> builder.field("@vocab").stringValue("http://schema.org/")), arrayBuilder -> arrayBuilder.addString("https://www.w3.org/ns/hydra/core#"));
    }

    @Override
    public void onFinishEmbeddedOperation(JSONObjectBuilder singleModelJSONObjectBuilder, JSONObjectBuilder operationJSONObjectBuilder, FunctionalList<String> embeddedPathElements, Operation operation) {
        Stream<String> tailStream = embeddedPathElements.tailStream();
        String head = embeddedPathElements.head();
        String[] tail = (String[])tailStream.toArray(String[]::new);
        operationJSONObjectBuilder.field("@id").stringValue("_:" + operation.getName());
        operationJSONObjectBuilder.field("@type").stringValue("Operation");
        singleModelJSONObjectBuilder.nestedField(head, tail).field("operation").arrayValue().add(operationJSONObjectBuilder);
    }

    @Override
    public void onFinishOperation(JSONObjectBuilder singleModelJSONObjectBuilder, JSONObjectBuilder operationJSONObjectBuilder, Operation operation) {
        operationJSONObjectBuilder.field("@id").stringValue("_:" + operation.getName());
        operationJSONObjectBuilder.field("@type").stringValue("Operation");
        singleModelJSONObjectBuilder.field("operation").arrayValue().add(operationJSONObjectBuilder);
    }
}

