/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.message.json.ld;

import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.form.FormField;
import com.liferay.apio.architect.impl.internal.message.json.FormMessageMapper;
import com.liferay.apio.architect.impl.internal.message.json.JSONObjectBuilder;
import javax.ws.rs.core.HttpHeaders;
import org.osgi.service.component.annotations.Component;

@Component
public class JSONLDFormMessageMapper
implements FormMessageMapper {
    @Override
    public String getMediaType() {
        return "application/ld+json";
    }

    @Override
    public void mapFormDescription(JSONObjectBuilder jsonObjectBuilder, String description) {
        jsonObjectBuilder.field("description").stringValue(description);
    }

    @Override
    public void mapFormField(JSONObjectBuilder jsonObjectBuilder, FormField formField) {
        jsonObjectBuilder.field("supportedProperty").arrayValue().add(builder -> {
            builder.field("@type").stringValue("SupportedProperty");
            builder.field("property").stringValue(formField.getName());
            builder.field("readable").booleanValue(false);
            builder.field("required").booleanValue(formField.isRequired());
            builder.field("writeable").booleanValue(true);
        });
    }

    @Override
    public void mapFormTitle(JSONObjectBuilder jsonObjectBuilder, String title) {
        jsonObjectBuilder.field("title").stringValue(title);
    }

    @Override
    public void mapFormURL(JSONObjectBuilder jsonObjectBuilder, String url) {
        jsonObjectBuilder.field("@id").stringValue(url);
    }

    @Override
    public void onFinish(JSONObjectBuilder jsonObjectBuilder, Form form, HttpHeaders httpHeaders) {
        jsonObjectBuilder.field("@type").stringValue("Class");
        jsonObjectBuilder.field("@context").arrayValue(arrayBuilder -> arrayBuilder.add(builder -> builder.field("@vocab").stringValue("http://schema.org/")), arrayBuilder -> arrayBuilder.addString("https://www.w3.org/ns/hydra/core#"));
    }
}

