/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.message.json.ld;

import com.liferay.apio.architect.impl.internal.documentation.Documentation;
import com.liferay.apio.architect.impl.internal.message.json.DocumentationMessageMapper;
import com.liferay.apio.architect.impl.internal.message.json.JSONObjectBuilder;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.operation.Operation;
import java.util.stream.Stream;
import javax.ws.rs.core.HttpHeaders;
import org.osgi.service.component.annotations.Component;

@Component
public class JSONLDDocumentationMessageMapper
implements DocumentationMessageMapper {
    @Override
    public String getMediaType() {
        return "application/ld+json";
    }

    @Override
    public void mapDescription(JSONObjectBuilder jsonObjectBuilder, String description) {
        jsonObjectBuilder.field("description").stringValue(description);
    }

    @Override
    public void mapOperation(JSONObjectBuilder jsonObjectBuilder, String resourceName, String type, Operation operation) {
        jsonObjectBuilder.field("@id").stringValue("_:" + operation.getName());
        jsonObjectBuilder.field("@type").stringValue("Operation");
        jsonObjectBuilder.field("method").stringValue(operation.getHttpMethod().toString());
        jsonObjectBuilder.field("returns").stringValue(this._getReturnValue(type, operation));
    }

    @Override
    public void mapProperty(JSONObjectBuilder jsonObjectBuilder, String fieldName) {
        jsonObjectBuilder.field("@type").stringValue("SupportedProperty");
        jsonObjectBuilder.field("property").stringValue(fieldName);
    }

    @Override
    public void mapResource(JSONObjectBuilder jsonObjectBuilder, String resourceType) {
        jsonObjectBuilder.field("@id").stringValue(resourceType);
        jsonObjectBuilder.field("@type").stringValue("Class");
        jsonObjectBuilder.field("title").stringValue(resourceType);
    }

    @Override
    public void mapResourceCollection(JSONObjectBuilder jsonObjectBuilder, String resourceType) {
        jsonObjectBuilder.field("@id").stringValue("vocab:" + resourceType + "Collection");
        jsonObjectBuilder.field("@type").stringValue("Class");
        jsonObjectBuilder.field("subClassOf").stringValue("Collection");
        jsonObjectBuilder.field("description").stringValue("A collection of " + resourceType);
        jsonObjectBuilder.field("title").stringValue(resourceType + "Collection");
        Stream.of("totalItems", "member", "numberOfItems").forEach(fieldName -> {
            JSONObjectBuilder propertyJsonObjectBuilder = new JSONObjectBuilder();
            this.onStartProperty(jsonObjectBuilder, propertyJsonObjectBuilder, (String)fieldName);
            this.mapProperty(propertyJsonObjectBuilder, (String)fieldName);
            this.onFinishProperty(jsonObjectBuilder, propertyJsonObjectBuilder, (String)fieldName);
        });
    }

    @Override
    public void mapTitle(JSONObjectBuilder jsonObjectBuilder, String title) {
        jsonObjectBuilder.field("title").stringValue(title);
    }

    @Override
    public void onFinishOperation(JSONObjectBuilder documentationJsonObjectBuilder, JSONObjectBuilder operationJsonObjectBuilder, Operation operation) {
        documentationJsonObjectBuilder.field("supportedOperation").arrayValue().add(operationJsonObjectBuilder);
    }

    @Override
    public void onFinishProperty(JSONObjectBuilder documentationJsonObjectBuilder, JSONObjectBuilder propertyJsonObjectBuilder, String formField) {
        documentationJsonObjectBuilder.field("supportedProperty").arrayValue().add(propertyJsonObjectBuilder);
    }

    @Override
    public void onFinishResource(JSONObjectBuilder documentationJsonObjectBuilder, JSONObjectBuilder resourceJsonObjectBuilder, String type) {
        documentationJsonObjectBuilder.field("supportedClass").arrayValue().add(resourceJsonObjectBuilder);
    }

    @Override
    public void onStart(JSONObjectBuilder jsonObjectBuilder, Documentation documentation, HttpHeaders httpHeaders) {
        jsonObjectBuilder.field("@context").arrayValue(arrayBuilder -> arrayBuilder.add(builder -> builder.field("@vocab").stringValue("http://schema.org/")), arrayBuilder -> arrayBuilder.addString("https://www.w3.org/ns/hydra/core#"), arrayBuilder -> arrayBuilder.add(builder -> builder.field("expects").fields(nestedBuilder -> nestedBuilder.field("@type").stringValue("@id"), nestedBuilder -> nestedBuilder.field("@id").stringValue("hydra:expects")), builder -> builder.field("returns").fields(nestedBuilder -> nestedBuilder.field("@id").stringValue("hydra:returns"), nestedBuilder -> nestedBuilder.field("@type").stringValue("@id"))));
        jsonObjectBuilder.field("@id").stringValue("/doc");
        jsonObjectBuilder.field("@type").stringValue("ApiDocumentation");
    }

    private String _getReturnValue(String resourceName, Operation operation) {
        String value = null;
        HTTPMethod httpMethod = operation.getHttpMethod();
        value = HTTPMethod.DELETE.equals((Object)httpMethod) ? "http://www.w3.org/2002/07/owl#Nothing" : (operation.isCollection() && httpMethod.equals((Object)HTTPMethod.GET) ? "Collection" : resourceName);
        return value;
    }
}

