/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.message.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class JSONObjectBuilder {
    private final JsonObject _jsonObject = new JsonObject();

    public JsonObject build() {
        return this._jsonObject;
    }

    public FieldStep field(String name) {
        return new FieldStep(name, this._jsonObject);
    }

    public FieldStep ifElseCondition(boolean condition, Function<JSONObjectBuilder, FieldStep> ifFunction, Function<JSONObjectBuilder, FieldStep> elseFunction) {
        if (condition) {
            return ifFunction.apply(this);
        }
        return elseFunction.apply(this);
    }

    public FieldStep nestedField(String parentName, String ... nestedNames) {
        FieldStep fieldStep = this.field(parentName);
        for (String nestedName : nestedNames) {
            fieldStep = fieldStep.field(nestedName);
        }
        return fieldStep;
    }

    public FieldStep nestedPrefixedField(String prefix, String parentName, String ... nestedNames) {
        FieldStep fieldStep = this.nestedField(prefix, parentName);
        for (String nestedName : nestedNames) {
            fieldStep = fieldStep.nestedField(prefix, nestedName);
        }
        return fieldStep;
    }

    public FieldStep nestedSuffixedField(String suffix, String parentName, String ... nestedNames) {
        FieldStep fieldStep = this.nestedField(parentName, suffix);
        for (String nestedName : nestedNames) {
            fieldStep = fieldStep.nestedField(nestedName, suffix);
        }
        return fieldStep;
    }

    public static class FieldStep {
        private final JsonObject _jsonObject;
        private final String _name;

        public FieldStep(String name, JsonObject jsonObject) {
            this._name = name;
            this._jsonObject = jsonObject;
        }

        public ArrayValueStep arrayValue() {
            JsonArray jsonArray = Optional.ofNullable(this._jsonObject.get(this._name)).filter(JsonElement::isJsonArray).map(JsonArray.class::cast).orElseGet(JsonArray::new);
            this._jsonObject.add(this._name, (JsonElement)jsonArray);
            return new ArrayValueStep(jsonArray);
        }

        @SafeVarargs
        public final void arrayValue(Consumer<ArrayValueStep> consumer, Consumer<ArrayValueStep> ... consumers) {
            ArrayValueStep arrayValueStep = this.arrayValue();
            consumer.accept(arrayValueStep);
            for (Consumer<ArrayValueStep> arrayValueStepConsumer : consumers) {
                arrayValueStepConsumer.accept(arrayValueStep);
            }
        }

        public void booleanValue(Boolean value) {
            this._jsonObject.addProperty(this._name, value);
        }

        public FieldStep field(String name) {
            JsonObject jsonObject = Optional.ofNullable(this._jsonObject.get(this._name)).filter(JsonElement::isJsonObject).map(JsonObject.class::cast).orElseGet(JsonObject::new);
            this._jsonObject.add(this._name, (JsonElement)jsonObject);
            return new FieldStep(name, jsonObject);
        }

        @SafeVarargs
        public final void fields(Consumer<FieldStep> consumer, Consumer<FieldStep> ... consumers) {
            consumer.accept(this);
            for (Consumer<FieldStep> fieldStepConsumer : consumers) {
                fieldStepConsumer.accept(this);
            }
        }

        public FieldStep ifCondition(boolean condition, Function<FieldStep, FieldStep> ifFunction) {
            if (condition) {
                return ifFunction.apply(this);
            }
            return this;
        }

        public FieldStep ifElseCondition(boolean condition, Function<FieldStep, FieldStep> ifFunction, Function<FieldStep, FieldStep> elseFunction) {
            if (condition) {
                return ifFunction.apply(this);
            }
            return elseFunction.apply(this);
        }

        public FieldStep nestedField(String parentName, String ... nestedNames) {
            FieldStep fieldStep = this.field(parentName);
            for (String nestedName : nestedNames) {
                fieldStep = fieldStep.field(nestedName);
            }
            return fieldStep;
        }

        public FieldStep nestedPrefixedField(String prefix, String parentName, String ... nestedNames) {
            FieldStep fieldStep = this.nestedField(prefix, parentName);
            for (String nestedName : nestedNames) {
                fieldStep = fieldStep.nestedField(prefix, nestedName);
            }
            return fieldStep;
        }

        public FieldStep nestedSuffixedField(String suffix, String parentName, String ... nestedNames) {
            FieldStep fieldStep = this.nestedField(parentName, suffix);
            for (String nestedName : nestedNames) {
                fieldStep = fieldStep.nestedField(nestedName, suffix);
            }
            return fieldStep;
        }

        public void numberValue(Number value) {
            this._jsonObject.addProperty(this._name, value);
        }

        public void stringValue(String value) {
            this._jsonObject.addProperty(this._name, value);
        }
    }

    public static class ArrayValueStep {
        private final JsonArray _jsonArray;

        public ArrayValueStep(JsonArray jsonArray) {
            this._jsonArray = jsonArray;
        }

        public void add(Consumer<JSONObjectBuilder> consumer) {
            JSONObjectBuilder jsonObjectBuilder = new JSONObjectBuilder();
            consumer.accept(jsonObjectBuilder);
            this.add(jsonObjectBuilder);
        }

        @SafeVarargs
        public final void add(Consumer<JSONObjectBuilder> consumer, Consumer<JSONObjectBuilder> ... consumers) {
            this.add(consumer);
            for (Consumer<JSONObjectBuilder> jsonObjectBuilderConsumer : consumers) {
                this.add(jsonObjectBuilderConsumer);
            }
        }

        public void add(JSONObjectBuilder jsonObjectBuilder) {
            this._jsonArray.add((JsonElement)jsonObjectBuilder.build());
        }

        public void addAllBooleans(Collection<Boolean> collection) {
            Stream<Boolean> stream = collection.stream();
            stream.forEach(arg_0 -> ((JsonArray)this._jsonArray).add(arg_0));
        }

        public void addAllJsonObjects(Collection<JsonObject> collection) {
            collection.forEach(arg_0 -> ((JsonArray)this._jsonArray).add(arg_0));
        }

        public void addAllNumbers(Collection<Number> collection) {
            collection.forEach(arg_0 -> ((JsonArray)this._jsonArray).add(arg_0));
        }

        public void addAllStrings(Collection<String> collection) {
            Stream<String> stream = collection.stream();
            stream.forEach(arg_0 -> ((JsonArray)this._jsonArray).add(arg_0));
        }

        public void addBoolean(Boolean value) {
            this._jsonArray.add(value);
        }

        public void addNumber(Number value) {
            this._jsonArray.add(value);
        }

        public void addString(String value) {
            this._jsonArray.add(value);
        }
    }
}

