/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.jaxrs.json.writer;

import com.liferay.apio.architect.file.BinaryFile;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.impl.internal.wiring.osgi.util.GenericUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.osgi.service.component.annotations.Component;

@Provider
@Component(property={"osgi.jaxrs.application.select=(liferay.apio.architect.application=true)", "osgi.jaxrs.extension=true"})
public class BinaryResourceBodyWriter
implements MessageBodyWriter<Try.Success<BinaryFile>> {
    public long getSize(Try.Success<BinaryFile> singleModelSuccess, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> aClass, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Try classTry = GenericUtil.getFirstGenericTypeArgumentFromTypeTry(genericType, Try.class);
        return classTry.filter(BinaryFile.class::equals).isSuccess();
    }

    public void writeTo(Try.Success<BinaryFile> success, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        BinaryFile binaryFile = (BinaryFile)success.getValue();
        multivaluedMap.put((Object)"Content-Type", Collections.singletonList(binaryFile.getMimeType()));
        multivaluedMap.put((Object)"Content-Length", Collections.singletonList(binaryFile.getSize()));
        byte[] bytes = new byte[1024];
        InputStream inputStream = binaryFile.getInputStream();
        int value = -1;
        while ((value = inputStream.read(bytes)) != -1) {
            outputStream.write(bytes, 0, value);
        }
        outputStream.close();
    }
}

