/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.jaxrs.json.util;

import com.liferay.apio.architect.error.APIError;
import com.liferay.apio.architect.impl.internal.message.json.ErrorMessageMapper;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.exception.mapper.ExceptionMapperManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.message.json.ErrorMessageMapperManager;
import com.liferay.apio.architect.impl.internal.writer.ErrorWriter;
import com.liferay.apio.architect.logger.ApioLogger;
import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ErrorUtil.class})
public class ErrorUtil {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private ApioLogger _apioLogger;
    @Reference
    private ErrorMessageMapperManager _errorMessageMapperManager;
    @Reference
    private ExceptionMapperManager _exceptionMapperManager;

    public Response getErrorResponse(Exception exception, Request request, HttpHeaders httpHeaders) {
        Optional<APIError> apiErrorOptional = this._exceptionMapperManager.map(exception);
        if (!apiErrorOptional.isPresent()) {
            Class<WebApplicationException> exceptionClass = exception.getClass();
            if (this._apioLogger != null) {
                this._apioLogger.warning("No exception mapper found for " + exceptionClass);
            }
            if (exceptionClass.isAssignableFrom(WebApplicationException.class)) {
                WebApplicationException webApplicationException = (WebApplicationException)exception;
                return webApplicationException.getResponse();
            }
            return Response.serverError().build();
        }
        APIError apiError = apiErrorOptional.get();
        if (this._apioLogger != null) {
            this._apioLogger.error(apiError);
        }
        int statusCode = apiError.getStatusCode();
        Optional<ErrorMessageMapper> errorMessageMapperOptional = this._errorMessageMapperManager.getErrorMessageMapperOptional(request);
        return errorMessageMapperOptional.map(errorMessageMapper -> {
            String result = ErrorWriter.writeError(errorMessageMapper, apiError, httpHeaders);
            return Response.status((int)statusCode).type(errorMessageMapper.getMediaType()).entity((Object)result).build();
        }).orElseGet(() -> Response.status((int)statusCode).build());
    }
}

