/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.jaxrs.json.reader;

import com.liferay.apio.architect.file.BinaryFile;
import com.liferay.apio.architect.form.Body;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.osgi.service.component.annotations.Component;

@Consumes(value={"multipart/form-data"})
@Provider
@Component(property={"osgi.jaxrs.application.select=(liferay.apio.architect.application=true)", "osgi.jaxrs.extension=true"})
public class MultipartBodyMessageBodyReader
implements MessageBodyReader<Body> {
    private static final Pattern _arrayPattern = Pattern.compile("([A-Z|a-z]+)\\[([0-9]+)]");
    @Context
    private HttpServletRequest _httpServletRequest;

    public boolean isReadable(Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Body readFrom(Class<Body> clazz, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)this._httpServletRequest)) {
            throw new BadRequestException("Request body is not a valid multipart form");
        }
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)fileItemFactory);
        try {
            List fileItems = servletFileUpload.parseRequest(this._httpServletRequest);
            Iterator iterator = fileItems.iterator();
            HashMap values = new HashMap();
            HashMap binaryFiles = new HashMap();
            HashMap indexedValueLists = new HashMap();
            HashMap indexedFileLists = new HashMap();
            while (iterator.hasNext()) {
                FileItem fileItem = (FileItem)iterator.next();
                String name = fileItem.getFieldName();
                Matcher matcher = _arrayPattern.matcher(name);
                if (matcher.matches()) {
                    int index = Integer.parseInt(matcher.group(2));
                    String actualName = matcher.group(1);
                    this._storeFileItem(fileItem, value -> {
                        Map indexedMap = indexedValueLists.computeIfAbsent(actualName, __ -> new HashMap());
                        indexedMap.put(index, value);
                    }, binaryFile -> {
                        Map indexedMap = indexedFileLists.computeIfAbsent(actualName, __ -> new HashMap());
                        indexedMap.put(index, binaryFile);
                    });
                    continue;
                }
                this._storeFileItem(fileItem, value -> values.put(name, value), binaryFile -> binaryFiles.put(name, binaryFile));
            }
            Map valueLists = this._flattenMap(indexedValueLists);
            Map fileLists = this._flattenMap(indexedFileLists);
            return Body.create(key -> Optional.ofNullable(values.get(key)), key -> Optional.ofNullable(valueLists.get(key)), key -> Optional.ofNullable(fileLists.get(key)), key -> Optional.ofNullable(binaryFiles.get(key)));
        }
        catch (IndexOutOfBoundsException | NumberFormatException | FileUploadException e) {
            throw new BadRequestException("Request body is not a valid multipart form", e);
        }
    }

    private <T> Map<String, List<T>> _flattenMap(Map<String, Map<Integer, T>> indexedValueLists) {
        Set<Map.Entry<String, Map<Integer, T>>> entries = indexedValueLists.entrySet();
        Stream stream = entries.stream();
        return stream.sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, v -> {
            Map map = (Map)v.getValue();
            return new ArrayList(map.values());
        }));
    }

    private void _storeFileItem(FileItem fileItem, Consumer<String> valueConsumer, Consumer<BinaryFile> fileConsumer) throws IOException {
        if (fileItem.isFormField()) {
            InputStream stream = fileItem.getInputStream();
            valueConsumer.accept(Streams.asString((InputStream)stream));
        } else {
            BinaryFile binaryFile = new BinaryFile(fileItem.getInputStream(), Long.valueOf(fileItem.getSize()), fileItem.getContentType());
            fileConsumer.accept(binaryFile);
        }
    }
}

