/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.jaxrs.json.reader;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.functional.Try;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.osgi.service.component.annotations.Component;

@Consumes(value={"application/json"})
@Provider
@Component(property={"osgi.jaxrs.application.select=(liferay.apio.architect.application=true)", "osgi.jaxrs.extension=true"})
public class JSONBodyMessageBodyReader
implements MessageBodyReader<Body> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Body readFrom(Class<Body> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return JSONBodyMessageBodyReader._getBody(entityStream);
    }

    private static Body _getBody(InputStream entityStream) {
        Gson gson = new Gson();
        return (Body)Try.fromFallibleWithResources(() -> new InputStreamReader(entityStream, StandardCharsets.UTF_8), streamReader -> (JsonObject)gson.fromJson((Reader)streamReader, JsonObject.class)).map(JSONBodyMessageBodyReader::_getBody).recover(__ -> JSONBodyMessageBodyReader._getListBody(entityStream, gson));
    }

    private static Body _getBody(JsonObject jsonObject) {
        return Body.create(key -> Optional.ofNullable(jsonObject.get(key)).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString), key -> Optional.ofNullable(jsonObject.get(key)).filter(JsonElement::isJsonArray).map(JsonElement::getAsJsonArray).map(JSONBodyMessageBodyReader::_getJsonElements).map(Collection::stream).map(stream -> stream.filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).collect(Collectors.toList())));
    }

    private static List<JsonElement> _getJsonElements(JsonArray jsonArray) {
        ArrayList<JsonElement> jsonElements = new ArrayList<JsonElement>();
        Iterator iterator = jsonArray.iterator();
        iterator.forEachRemaining(jsonElements::add);
        return jsonElements;
    }

    private static Body _getListBody(InputStream entityStream, Gson gson) {
        return (Body)Try.fromFallibleWithResources(() -> new InputStreamReader(entityStream, StandardCharsets.UTF_8), streamReader -> (JsonArray)gson.fromJson((Reader)streamReader, JsonArray.class)).map(JSONBodyMessageBodyReader::_getJsonElements).map(Collection::stream).map(stream -> stream.filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).map(JSONBodyMessageBodyReader::_getBody).collect(Collectors.toList())).map(Body::create).orElseThrow(() -> new BadRequestException("Body is not a valid JSON"));
    }
}

