/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.form;

import com.liferay.apio.architect.alias.IdentifierFunction;
import com.liferay.apio.architect.file.BinaryFile;
import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.form.FieldType;
import com.liferay.apio.architect.form.FormField;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.impl.internal.alias.form.FieldFormBiConsumer;
import com.liferay.apio.architect.impl.internal.date.DateTransformer;
import com.liferay.apio.architect.impl.internal.form.FormFieldImpl;
import com.liferay.apio.architect.impl.internal.url.URLCreator;
import com.liferay.apio.architect.uri.Path;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;

public class FormUtil {
    public static <T> FieldFormBiConsumer<T, Boolean> getOptionalBoolean(Body body, T t) {
        return (key, function) -> FormUtil._getBoolean(body, key, false, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<Boolean>> getOptionalBooleanList(Body body, T t) {
        return (key, function) -> FormUtil._getBooleanList(body, key, false, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, Date> getOptionalDate(Body body, T t) {
        return (key, function) -> FormUtil._getDate(body, key, false, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<Date>> getOptionalDateList(Body body, T t) {
        return (key, function) -> FormUtil._getDateList(body, key, false, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, Double> getOptionalDouble(Body body, T t) {
        return (key, function) -> FormUtil._getDouble(body, key, false, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<Double>> getOptionalDoubleList(Body body, T t) {
        return (key, function) -> FormUtil._getDoubleList(body, key, false, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, BinaryFile> getOptionalFile(Body body, T t) {
        return (key, function) -> FormUtil._getFile(body, key, false, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<BinaryFile>> getOptionalFileList(Body body, T t) {
        return (key, function) -> FormUtil._getFileList(body, key, false, (Consumer)function.apply(t));
    }

    public static Stream<FormField> getOptionalFormFieldStream(Map<String, ?> map, FieldType fieldType) {
        return FormUtil._getFormFieldStream(map, false, fieldType);
    }

    public static <T> BiConsumer<String, Function<T, Consumer<?>>> getOptionalLinkedModel(Body body, T t, IdentifierFunction identifierFunction) {
        return (key, function) -> FormUtil._getLinkedModelValueField(body, key, false, (Consumer)function.apply(t), identifierFunction);
    }

    public static <T> FieldFormBiConsumer<T, Long> getOptionalLong(Body body, T t) {
        return (key, function) -> FormUtil._getLong(body, key, false, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<Long>> getOptionalLongList(Body body, T t) {
        return (key, function) -> FormUtil._getLongList(body, key, false, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, String> getOptionalString(Body body, T t) {
        return (key, function) -> FormUtil._getString(body, key, false, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<String>> getOptionalStringList(Body body, T t) {
        return (key, function) -> FormUtil._getListField(body, key, false, (Consumer)function.apply(t), Function.identity());
    }

    public static <T> FieldFormBiConsumer<T, Boolean> getRequiredBoolean(Body body, T t) {
        return (key, function) -> FormUtil._getBoolean(body, key, true, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<Boolean>> getRequiredBooleanList(Body body, T t) {
        return (key, function) -> FormUtil._getBooleanList(body, key, true, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, Date> getRequiredDate(Body body, T t) {
        return (key, function) -> FormUtil._getDate(body, key, true, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<Date>> getRequiredDateList(Body body, T t) {
        return (key, function) -> FormUtil._getDateList(body, key, true, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, Double> getRequiredDouble(Body body, T t) {
        return (key, function) -> FormUtil._getDouble(body, key, true, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<Double>> getRequiredDoubleList(Body body, T t) {
        return (key, function) -> FormUtil._getDoubleList(body, key, true, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, BinaryFile> getRequiredFile(Body body, T t) {
        return (key, function) -> FormUtil._getFile(body, key, true, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<BinaryFile>> getRequiredFileList(Body body, T t) {
        return (key, function) -> FormUtil._getFileList(body, key, true, (Consumer)function.apply(t));
    }

    public static Stream<FormField> getRequiredFormFieldStream(Map<String, ?> map, FieldType fieldType) {
        return FormUtil._getFormFieldStream(map, true, fieldType);
    }

    public static <T> BiConsumer<String, Function<T, Consumer>> getRequiredLinkedModel(Body body, T t, IdentifierFunction identifierFunction) {
        return (key, function) -> FormUtil._getLinkedModelValueField(body, key, true, (Consumer)function.apply(t), identifierFunction);
    }

    public static <T> FieldFormBiConsumer<T, Long> getRequiredLong(Body body, T t) {
        return (key, function) -> FormUtil._getLong(body, key, true, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<Long>> getRequiredLongList(Body body, T t) {
        return (key, function) -> FormUtil._getLongList(body, key, true, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, String> getRequiredString(Body body, T t) {
        return (key, function) -> FormUtil._getString(body, key, true, (Consumer)function.apply(t));
    }

    public static <T> FieldFormBiConsumer<T, List<String>> getRequiredStringList(Body body, T t) {
        return (key, function) -> FormUtil._getListField(body, key, true, (Consumer)function.apply(t), Function.identity());
    }

    private static void _getBoolean(Body body, String key, boolean required, Consumer<Boolean> consumer) {
        FormUtil._getValueField(body, key, required, value -> consumer.accept(Boolean.valueOf(value)));
    }

    private static void _getBooleanList(Body body, String key, boolean required, Consumer<List<Boolean>> consumer) {
        FormUtil._getListField(body, key, required, consumer, stream -> stream.map(Boolean::valueOf));
    }

    private static void _getDate(Body body, String key, boolean required, Consumer<Date> consumer) {
        String message = FormUtil._getWrongDateMessage(key);
        FormUtil._getString(body, key, required, string -> {
            Try<Date> dateTry = DateTransformer.asDate(string);
            Date date = (Date)dateTry.orElseThrow(() -> new BadRequestException(message));
            consumer.accept(date);
        });
    }

    private static void _getDateList(Body body, String key, boolean required, Consumer<List<Date>> consumer) {
        String message = FormUtil._getWrongDateMessage(key);
        FormUtil._getListField(body, key, required, consumer, stream -> stream.map(Try::success).map(stringTry -> (Date)stringTry.flatMap(DateTransformer::asDate).orElseThrow(() -> new BadRequestException(message))));
    }

    private static void _getDouble(Body body, String key, boolean required, Consumer<Double> consumer) {
        FormUtil._getNumber(body, key, required, Number::doubleValue, consumer);
    }

    private static void _getDoubleList(Body body, String key, boolean required, Consumer<List<Double>> consumer) {
        FormUtil._getNumberList(body, key, required, Number::doubleValue, consumer);
    }

    private static void _getFile(Body body, String key, boolean required, Consumer<BinaryFile> consumer) {
        Optional optional = body.getFileOptional(key);
        if (optional.isPresent()) {
            consumer.accept((BinaryFile)optional.get());
        } else if (required) {
            throw new BadRequestException("Field \"" + key + "\" is required");
        }
    }

    private static void _getFileList(Body body, String key, boolean required, Consumer<List<BinaryFile>> consumer) {
        Optional optional = body.getFileListOptional(key);
        if (optional.isPresent()) {
            consumer.accept((List<BinaryFile>)optional.get());
        } else if (required) {
            throw new BadRequestException("Field \"" + key + "\" is required");
        }
    }

    private static Stream<FormField> _getFormFieldStream(Map<String, ?> map, Boolean required, FieldType fieldType) {
        Set<String> keys = map.keySet();
        Stream stream = keys.stream();
        return stream.map(name -> new FormFieldImpl((String)name, required, fieldType));
    }

    private static void _getLinkedModelValueField(Body body, String key, boolean required, Consumer consumer, IdentifierFunction<?> identifierFunction) {
        Optional optional = body.getValueOptional(key);
        if (optional.isPresent()) {
            String url = (String)optional.get();
            Path path = URLCreator.getPath(url);
            Object object = identifierFunction.apply((Object)path);
            consumer.accept(object);
        } else if (required) {
            throw new BadRequestException("Field \"" + key + "\" is required");
        }
    }

    private static <T> void _getListField(Body body, String key, boolean required, Consumer<List<T>> consumer, Function<Stream<String>, Stream<T>> function) {
        Optional optional = body.getValueListOptional(key);
        optional.map(Collection::stream).map(function).map(stream -> stream.collect(Collectors.toList())).ifPresent(consumer);
        if (!optional.isPresent() && required) {
            throw new BadRequestException("Field \"" + key + "\" is required");
        }
    }

    private static void _getLong(Body body, String key, boolean required, Consumer<Long> consumer) {
        FormUtil._getNumber(body, key, required, Number::longValue, consumer);
    }

    private static void _getLongList(Body body, String key, boolean required, Consumer<List<Long>> consumer) {
        FormUtil._getNumberList(body, key, required, Number::longValue, consumer);
    }

    private static <T extends Number> void _getNumber(Body body, String key, boolean required, Function<Number, T> function, Consumer<T> consumer) {
        FormUtil._getValueField(body, key, required, value -> Try.success((Object)value).map(NumberFormat.getInstance()::parse).map(function::apply).voidFold(__ -> {
            throw new BadRequestException("Field \"" + key + "\" should be a number");
        }, consumer::accept));
    }

    private static <T extends Number> void _getNumberList(Body body, String key, boolean required, Function<Number, T> function, Consumer<List<T>> consumer) {
        FormUtil._getListField(body, key, required, consumer, stream -> stream.map(Try::success).map(stringTry -> stringTry.map(NumberFormat.getInstance()::parse).map(function::apply)).map(tTry -> (Number)tTry.orElseThrow(() -> new BadRequestException("Field \"" + key + "\" should be a number"))));
    }

    private static void _getString(Body body, String key, boolean required, Consumer<String> consumer) {
        FormUtil._getValueField(body, key, required, consumer);
    }

    private static void _getValueField(Body body, String key, boolean required, Consumer<String> consumer) {
        Optional optional = body.getValueOptional(key);
        if (optional.isPresent()) {
            consumer.accept((String)optional.get());
        } else if (required) {
            throw new BadRequestException("Field \"" + key + "\" is required");
        }
    }

    private static String _getWrongDateMessage(String key) {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("Field \"").append(key).append("\" should be a string date in ISO-8601 format: ").append("yyyy-MM-dd'T'HH:mm'Z'").toString();
    }

    private FormUtil() {
        throw new UnsupportedOperationException();
    }
}

