/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.form;

import com.liferay.apio.architect.alias.IdentifierFunction;
import com.liferay.apio.architect.file.BinaryFile;
import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.form.FieldType;
import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.form.FormField;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.impl.internal.form.FormUtil;
import com.liferay.apio.architect.language.AcceptLanguage;
import com.liferay.apio.architect.uri.Path;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;

public class FormImpl<T>
implements Form<T> {
    private Function<AcceptLanguage, String> _descriptionFunction;
    private final String _id;
    private final IdentifierFunction<?> _identifierFunction;
    private final Map<String, Function<T, Consumer<List<Boolean>>>> _optionalBooleanLists = new HashMap<String, Function<T, Consumer<List<Boolean>>>>();
    private final Map<String, Function<T, Consumer<Boolean>>> _optionalBooleans = new HashMap<String, Function<T, Consumer<Boolean>>>();
    private final Map<String, Function<T, Consumer<List<Date>>>> _optionalDateLists = new HashMap<String, Function<T, Consumer<List<Date>>>>();
    private final Map<String, Function<T, Consumer<Date>>> _optionalDates = new HashMap<String, Function<T, Consumer<Date>>>();
    private final Map<String, Function<T, Consumer<List<Double>>>> _optionalDoubleLists = new HashMap<String, Function<T, Consumer<List<Double>>>>();
    private final Map<String, Function<T, Consumer<Double>>> _optionalDoubles = new HashMap<String, Function<T, Consumer<Double>>>();
    private final Map<String, Function<T, Consumer<List<BinaryFile>>>> _optionalFileLists = new HashMap<String, Function<T, Consumer<List<BinaryFile>>>>();
    private final Map<String, Function<T, Consumer<BinaryFile>>> _optionalFiles = new HashMap<String, Function<T, Consumer<BinaryFile>>>();
    private final Map<String, Function<T, Consumer<?>>> _optionalLinkedModel = new HashMap();
    private final Map<String, Function<T, Consumer<List<Long>>>> _optionalLongLists = new HashMap<String, Function<T, Consumer<List<Long>>>>();
    private final Map<String, Function<T, Consumer<Long>>> _optionalLongs = new HashMap<String, Function<T, Consumer<Long>>>();
    private final Map<String, Function<T, Consumer<List<String>>>> _optionalStringLists = new HashMap<String, Function<T, Consumer<List<String>>>>();
    private final Map<String, Function<T, Consumer<String>>> _optionalStrings = new HashMap<String, Function<T, Consumer<String>>>();
    private final Map<String, Function<T, Consumer<List<Boolean>>>> _requiredBooleanLists = new HashMap<String, Function<T, Consumer<List<Boolean>>>>();
    private final Map<String, Function<T, Consumer<Boolean>>> _requiredBooleans = new HashMap<String, Function<T, Consumer<Boolean>>>();
    private final Map<String, Function<T, Consumer<List<Date>>>> _requiredDateLists = new HashMap<String, Function<T, Consumer<List<Date>>>>();
    private final Map<String, Function<T, Consumer<Date>>> _requiredDates = new HashMap<String, Function<T, Consumer<Date>>>();
    private final Map<String, Function<T, Consumer<List<Double>>>> _requiredDoubleLists = new HashMap<String, Function<T, Consumer<List<Double>>>>();
    private final Map<String, Function<T, Consumer<Double>>> _requiredDoubles = new HashMap<String, Function<T, Consumer<Double>>>();
    private final Map<String, Function<T, Consumer<List<BinaryFile>>>> _requiredFileLists = new HashMap<String, Function<T, Consumer<List<BinaryFile>>>>();
    private final Map<String, Function<T, Consumer<BinaryFile>>> _requiredFiles = new HashMap<String, Function<T, Consumer<BinaryFile>>>();
    private final Map<String, Function<T, Consumer>> _requiredLinkedModel = new HashMap<String, Function<T, Consumer>>();
    private final Map<String, Function<T, Consumer<List<Long>>>> _requiredLongLists = new HashMap<String, Function<T, Consumer<List<Long>>>>();
    private final Map<String, Function<T, Consumer<Long>>> _requiredLongs = new HashMap<String, Function<T, Consumer<Long>>>();
    private final Map<String, Function<T, Consumer<List<String>>>> _requiredStringLists = new HashMap<String, Function<T, Consumer<List<String>>>>();
    private final Map<String, Function<T, Consumer<String>>> _requiredStrings = new HashMap<String, Function<T, Consumer<String>>>();
    private Supplier<T> _supplier;
    private Function<AcceptLanguage, String> _titleFunction;

    public T get(Body body) {
        T t = this._supplier.get();
        this._optionalBooleans.forEach(FormUtil.getOptionalBoolean(body, t));
        this._optionalDates.forEach(FormUtil.getOptionalDate(body, t));
        this._optionalDoubles.forEach(FormUtil.getOptionalDouble(body, t));
        this._optionalFiles.forEach(FormUtil.getOptionalFile(body, t));
        this._optionalLinkedModel.forEach(FormUtil.getOptionalLinkedModel(body, t, this._identifierFunction));
        this._optionalLongs.forEach(FormUtil.getOptionalLong(body, t));
        this._optionalStrings.forEach(FormUtil.getOptionalString(body, t));
        this._requiredBooleans.forEach(FormUtil.getRequiredBoolean(body, t));
        this._requiredDates.forEach(FormUtil.getRequiredDate(body, t));
        this._requiredDoubles.forEach(FormUtil.getRequiredDouble(body, t));
        this._requiredFiles.forEach(FormUtil.getRequiredFile(body, t));
        this._requiredLinkedModel.forEach(FormUtil.getRequiredLinkedModel(body, t, this._identifierFunction));
        this._requiredLongs.forEach(FormUtil.getRequiredLong(body, t));
        this._requiredStrings.forEach(FormUtil.getRequiredString(body, t));
        this._optionalBooleanLists.forEach(FormUtil.getOptionalBooleanList(body, t));
        this._optionalDateLists.forEach(FormUtil.getOptionalDateList(body, t));
        this._optionalDoubleLists.forEach(FormUtil.getOptionalDoubleList(body, t));
        this._optionalFileLists.forEach(FormUtil.getOptionalFileList(body, t));
        this._optionalLongLists.forEach(FormUtil.getOptionalLongList(body, t));
        this._optionalStringLists.forEach(FormUtil.getOptionalStringList(body, t));
        this._requiredBooleanLists.forEach(FormUtil.getRequiredBooleanList(body, t));
        this._requiredDateLists.forEach(FormUtil.getRequiredDateList(body, t));
        this._requiredDoubleLists.forEach(FormUtil.getRequiredDoubleList(body, t));
        this._requiredFileLists.forEach(FormUtil.getRequiredFileList(body, t));
        this._requiredLongLists.forEach(FormUtil.getRequiredLongList(body, t));
        this._requiredStringLists.forEach(FormUtil.getRequiredStringList(body, t));
        return t;
    }

    public String getDescription(AcceptLanguage acceptLanguage) {
        return this._descriptionFunction.apply(acceptLanguage);
    }

    public List<FormField> getFormFields() {
        return Stream.of(FormUtil.getOptionalFormFieldStream(this._optionalBooleans, FieldType.BOOLEAN), FormUtil.getOptionalFormFieldStream(this._optionalBooleanLists, FieldType.BOOLEAN_LIST), FormUtil.getOptionalFormFieldStream(this._optionalDates, FieldType.DATE), FormUtil.getOptionalFormFieldStream(this._optionalDateLists, FieldType.DATE_LIST), FormUtil.getOptionalFormFieldStream(this._optionalDoubles, FieldType.DOUBLE), FormUtil.getOptionalFormFieldStream(this._optionalDoubleLists, FieldType.DOUBLE_LIST), FormUtil.getOptionalFormFieldStream(this._optionalFiles, FieldType.FILE), FormUtil.getOptionalFormFieldStream(this._optionalFileLists, FieldType.FILE_LIST), FormUtil.getOptionalFormFieldStream(this._optionalLongs, FieldType.LONG), FormUtil.getOptionalFormFieldStream(this._optionalLongLists, FieldType.LONG_LIST), FormUtil.getOptionalFormFieldStream(this._optionalStrings, FieldType.STRING), FormUtil.getOptionalFormFieldStream(this._optionalStringLists, FieldType.STRING_LIST), FormUtil.getRequiredFormFieldStream(this._requiredBooleans, FieldType.BOOLEAN), FormUtil.getRequiredFormFieldStream(this._requiredBooleanLists, FieldType.BOOLEAN_LIST), FormUtil.getRequiredFormFieldStream(this._requiredDates, FieldType.DATE), FormUtil.getRequiredFormFieldStream(this._requiredDateLists, FieldType.DATE_LIST), FormUtil.getRequiredFormFieldStream(this._requiredDoubles, FieldType.DOUBLE), FormUtil.getRequiredFormFieldStream(this._requiredDoubleLists, FieldType.DOUBLE_LIST), FormUtil.getRequiredFormFieldStream(this._requiredFiles, FieldType.FILE), FormUtil.getRequiredFormFieldStream(this._requiredFileLists, FieldType.FILE_LIST), FormUtil.getRequiredFormFieldStream(this._requiredLinkedModel, FieldType.LINKED_MODEL), FormUtil.getRequiredFormFieldStream(this._requiredLongs, FieldType.LONG), FormUtil.getRequiredFormFieldStream(this._requiredLongLists, FieldType.LONG_LIST), FormUtil.getRequiredFormFieldStream(this._requiredStrings, FieldType.STRING), FormUtil.getRequiredFormFieldStream(this._requiredStringLists, FieldType.STRING_LIST)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public String getId() {
        return this._id;
    }

    public List<T> getList(Body body) {
        Optional optional = body.getBodyMembersOptional();
        List bodyMembers = (List)optional.orElseThrow(() -> new BadRequestException("Body does not contain members"));
        Stream stream = bodyMembers.stream();
        return stream.map(this::get).collect(Collectors.toList());
    }

    public String getTitle(AcceptLanguage acceptLanguage) {
        return this._titleFunction.apply(acceptLanguage);
    }

    private FormImpl(List<String> paths, IdentifierFunction<?> identifierFunction) {
        this._id = String.join((CharSequence)"/", paths);
        this._identifierFunction = identifierFunction;
    }

    public static class BuilderImpl<T>
    implements Form.Builder<T>,
    Form.Builder.FieldStep<T>,
    Form.Builder.ConstructorStep<T>,
    Form.Builder.DescriptionStep<T> {
        private final FormImpl<T> _form;

        public static <T> BuilderImpl<T> empty() {
            return new BuilderImpl<T>(Collections.emptyList(), __ -> null);
        }

        public BuilderImpl(List<String> paths, Function<Path, ?> identifierFunction) {
            this._form = new FormImpl(paths, identifierFunction::apply);
        }

        public Form.Builder.FieldStep<T> addOptionalBoolean(String key, BiConsumer<T, Boolean> biConsumer) {
            ((FormImpl)this._form)._optionalBooleans.put(key, t -> aBoolean -> biConsumer.accept((Object)t, (Boolean)aBoolean));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalBooleanList(String key, BiConsumer<T, List<Boolean>> biConsumer) {
            ((FormImpl)this._form)._optionalBooleanLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Boolean>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalDate(String key, BiConsumer<T, Date> biConsumer) {
            ((FormImpl)this._form)._optionalDates.put(key, t -> date -> biConsumer.accept((Object)t, (Date)date));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalDateList(String key, BiConsumer<T, List<Date>> biConsumer) {
            ((FormImpl)this._form)._optionalDateLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Date>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalDouble(String key, BiConsumer<T, Double> biConsumer) {
            ((FormImpl)this._form)._optionalDoubles.put(key, t -> aDouble -> biConsumer.accept((Object)t, (Double)aDouble));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalDoubleList(String key, BiConsumer<T, List<Double>> biConsumer) {
            ((FormImpl)this._form)._optionalDoubleLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Double>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalFile(String key, BiConsumer<T, BinaryFile> biConsumer) {
            ((FormImpl)this._form)._optionalFiles.put(key, t -> binaryFile -> biConsumer.accept((Object)t, (BinaryFile)binaryFile));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalFileList(String key, BiConsumer<T, List<BinaryFile>> biConsumer) {
            ((FormImpl)this._form)._optionalFileLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<BinaryFile>)list));
            return this;
        }

        public <C> Form.Builder.FieldStep<T> addOptionalLinkedModel(String key, Class<? extends Identifier<C>> aClass, BiConsumer<T, C> biConsumer) {
            ((FormImpl)this._form)._optionalLinkedModel.put(key, t -> c -> biConsumer.accept(t, c));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalLong(String key, BiConsumer<T, Long> biConsumer) {
            ((FormImpl)this._form)._optionalLongs.put(key, t -> aLong -> biConsumer.accept((Object)t, (Long)aLong));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalLongList(String key, BiConsumer<T, List<Long>> biConsumer) {
            ((FormImpl)this._form)._optionalLongLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Long>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalString(String key, BiConsumer<T, String> biConsumer) {
            ((FormImpl)this._form)._optionalStrings.put(key, t -> string -> biConsumer.accept((Object)t, (String)string));
            return this;
        }

        public Form.Builder.FieldStep<T> addOptionalStringList(String key, BiConsumer<T, List<String>> biConsumer) {
            ((FormImpl)this._form)._optionalStringLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<String>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredBoolean(String key, BiConsumer<T, Boolean> biConsumer) {
            ((FormImpl)this._form)._requiredBooleans.put(key, t -> aBoolean -> biConsumer.accept((Object)t, (Boolean)aBoolean));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredBooleanList(String key, BiConsumer<T, List<Boolean>> biConsumer) {
            ((FormImpl)this._form)._requiredBooleanLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Boolean>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredDate(String key, BiConsumer<T, Date> biConsumer) {
            ((FormImpl)this._form)._requiredDates.put(key, t -> date -> biConsumer.accept((Object)t, (Date)date));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredDateList(String key, BiConsumer<T, List<Date>> biConsumer) {
            ((FormImpl)this._form)._requiredDateLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Date>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredDouble(String key, BiConsumer<T, Double> biConsumer) {
            ((FormImpl)this._form)._requiredDoubles.put(key, t -> aDouble -> biConsumer.accept((Object)t, (Double)aDouble));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredDoubleList(String key, BiConsumer<T, List<Double>> biConsumer) {
            ((FormImpl)this._form)._requiredDoubleLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Double>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredFile(String key, BiConsumer<T, BinaryFile> biConsumer) {
            ((FormImpl)this._form)._requiredFiles.put(key, t -> binaryFile -> biConsumer.accept((Object)t, (BinaryFile)binaryFile));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredFileList(String key, BiConsumer<T, List<BinaryFile>> biConsumer) {
            ((FormImpl)this._form)._requiredFileLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<BinaryFile>)list));
            return this;
        }

        public <C> Form.Builder.FieldStep<T> addRequiredLinkedModel(String key, Class<? extends Identifier<C>> aClass, BiConsumer<T, C> biConsumer) {
            ((FormImpl)this._form)._requiredLinkedModel.put(key, t -> c -> biConsumer.accept(t, c));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredLong(String key, BiConsumer<T, Long> biConsumer) {
            ((FormImpl)this._form)._requiredLongs.put(key, t -> aLong -> biConsumer.accept((Object)t, (Long)aLong));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredLongList(String key, BiConsumer<T, List<Long>> biConsumer) {
            ((FormImpl)this._form)._requiredLongLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<Long>)list));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredString(String key, BiConsumer<T, String> biConsumer) {
            ((FormImpl)this._form)._requiredStrings.put(key, t -> string -> biConsumer.accept((Object)t, (String)string));
            return this;
        }

        public Form.Builder.FieldStep<T> addRequiredStringList(String key, BiConsumer<T, List<String>> biConsumer) {
            ((FormImpl)this._form)._requiredStringLists.put(key, t -> list -> biConsumer.accept((Object)t, (List<String>)list));
            return this;
        }

        public Form<T> build() {
            return this._form;
        }

        public Form.Builder.FieldStep<T> constructor(Supplier<T> supplier) {
            ((FormImpl)this._form)._supplier = supplier;
            return this;
        }

        public Form.Builder.ConstructorStep<T> description(Function<AcceptLanguage, String> descriptionFunction) {
            ((FormImpl)this._form)._descriptionFunction = descriptionFunction;
            return this;
        }

        public Form.Builder.DescriptionStep<T> title(Function<AcceptLanguage, String> titleFunction) {
            ((FormImpl)this._form)._titleFunction = titleFunction;
            return this;
        }
    }
}

