/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.endpoint;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.liferay.apio.architect.documentation.APIDescription;
import com.liferay.apio.architect.documentation.APITitle;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.impl.internal.documentation.Documentation;
import com.liferay.apio.architect.impl.internal.endpoint.BinaryEndpoint;
import com.liferay.apio.architect.impl.internal.endpoint.ExceptionSupplierUtil;
import com.liferay.apio.architect.impl.internal.endpoint.FormEndpoint;
import com.liferay.apio.architect.impl.internal.endpoint.PageEndpointImpl;
import com.liferay.apio.architect.impl.internal.endpoint.RootEndpoint;
import com.liferay.apio.architect.impl.internal.url.ServerURL;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.provider.ProviderManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.representable.IdentifierClassManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.representable.RepresentableManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.router.CollectionRouterManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.router.ItemRouterManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.router.NestedCollectionRouterManager;
import com.liferay.apio.architect.impl.internal.wiring.osgi.manager.uri.mapper.PathIdentifierMapperManager;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.uri.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class RootEndpointImpl
implements RootEndpoint {
    @Reference
    private CollectionRouterManager _collectionRouterManager;
    private Documentation _documentation;
    @Context
    private HttpServletRequest _httpServletRequest;
    @Reference
    private IdentifierClassManager _identifierClassManager;
    @Reference
    private ItemRouterManager _itemRouterManager;
    @Reference
    private NestedCollectionRouterManager _nestedCollectionRouterManager;
    @Reference
    private PathIdentifierMapperManager _pathIdentifierMapperManager;
    @Reference
    private ProviderManager _providerManager;
    @Reference
    private RepresentableManager _representableManager;

    @Activate
    public void activate() {
        this._documentation = new Documentation(() -> this._provide(APITitle.class), () -> this._provide(APIDescription.class), () -> this._representableManager.getRepresentors(), () -> this._collectionRouterManager.getCollectionRoutes(), () -> this._itemRouterManager.getItemRoutes(), () -> this._nestedCollectionRouterManager.getNestedCollectionRoutes());
    }

    @Override
    public BinaryEndpoint binaryEndpoint() {
        return new BinaryEndpoint(this._representableManager::getRepresentorOptional, this::_getSingleModelTry);
    }

    @Override
    public Documentation documentation() {
        return this._documentation;
    }

    @Override
    public FormEndpoint formEndpoint() {
        return new FormEndpoint(this._collectionRouterManager::getCollectionRoutesOptional, this._itemRouterManager::getItemRoutesOptional, this._nestedCollectionRouterManager::getNestedCollectionRoutesOptional);
    }

    @Override
    public Response home() {
        List<String> resourceNames = this._collectionRouterManager.getResourceNames();
        ServerURL serverURL = this._providerManager.provideMandatory(this._httpServletRequest, ServerURL.class);
        JsonObject resourcesJsonObject = new JsonObject();
        resourceNames.forEach(name -> {
            String url = serverURL.get() + "/p/" + name;
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("href", url);
            resourcesJsonObject.add(name, (JsonElement)jsonObject);
        });
        JsonObject rootJsonObject = new JsonObject();
        rootJsonObject.add("resources", (JsonElement)resourcesJsonObject);
        return Response.ok((Object)rootJsonObject.toString()).type(MediaType.valueOf((String)"application/json")).build();
    }

    @Override
    public PageEndpointImpl pageEndpoint(String name) {
        return new PageEndpointImpl(name, this._httpServletRequest, this._identifierClassManager::getIdentifierClassOptional, id -> this._getSingleModelTry(name, (String)id), () -> this._collectionRouterManager.getCollectionRoutesOptional(name), () -> this._representableManager.getRepresentorOptional(name), () -> this._itemRouterManager.getItemRoutesOptional(name), nestedName -> this._nestedCollectionRouterManager.getNestedCollectionRoutesOptional(name, (String)nestedName), this._pathIdentifierMapperManager::mapToIdentifierOrFail);
    }

    private <T, S> Try<SingleModel<T>> _getSingleModelTry(String name, String id) {
        return Try.success((Object)name).mapOptional(this._itemRouterManager::getItemRoutesOptional).mapOptional(ItemRoutes::getItemFunctionOptional, ExceptionSupplierUtil.notFound(name, id)).flatMap(function -> (Try)((Function)function.apply((Object)this._httpServletRequest)).apply(this._pathIdentifierMapperManager.mapToIdentifierOrFail(new Path(name, id))));
    }

    private <T> Optional<T> _provide(Class<T> clazz) {
        return this._providerManager.provideOptional(this._httpServletRequest, clazz);
    }
}

