/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.endpoint;

import com.liferay.apio.architect.alias.IdentifierFunction;
import com.liferay.apio.architect.consumer.throwable.ThrowableConsumer;
import com.liferay.apio.architect.form.Body;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.impl.internal.endpoint.ExceptionSupplierUtil;
import com.liferay.apio.architect.impl.internal.endpoint.PageEndpoint;
import com.liferay.apio.architect.operation.HTTPMethod;
import com.liferay.apio.architect.pagination.Page;
import com.liferay.apio.architect.related.RelatedCollection;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.apio.architect.single.model.SingleModel;
import com.liferay.apio.architect.uri.Path;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

public class PageEndpointImpl<T, S>
implements PageEndpoint<T> {
    private final Supplier<Optional<CollectionRoutes<T, S>>> _collectionRoutesSupplier;
    private final HttpServletRequest _httpServletRequest;
    private final Function<String, Optional<Class<Identifier>>> _identifierClassFunction;
    private final IdentifierFunction<S> _identifierFunction;
    private final Supplier<Optional<ItemRoutes<T, S>>> _itemRoutesSupplier;
    private final String _name;
    private final Function<String, Optional<NestedCollectionRoutes<T, S, Object>>> _nestedCollectionRoutesFunction;
    private final Supplier<Optional<Representor<T>>> _representorSupplier;
    private final Function<String, Try<SingleModel<T>>> _singleModelFunction;

    public PageEndpointImpl(String name, HttpServletRequest httpServletRequest, Function<String, Optional<Class<Identifier>>> identifierClassFunction, Function<String, Try<SingleModel<T>>> singleModelFunction, Supplier<Optional<CollectionRoutes<T, S>>> collectionRoutesSupplier, Supplier<Optional<Representor<T>>> representorSupplier, Supplier<Optional<ItemRoutes<T, S>>> itemRoutesSupplier, Function<String, Optional<NestedCollectionRoutes<T, S, Object>>> nestedCollectionRoutesFunction, IdentifierFunction<S> identifierFunction) {
        this._name = name;
        this._httpServletRequest = httpServletRequest;
        this._identifierClassFunction = identifierClassFunction;
        this._singleModelFunction = singleModelFunction;
        this._collectionRoutesSupplier = collectionRoutesSupplier;
        this._representorSupplier = representorSupplier;
        this._itemRoutesSupplier = itemRoutesSupplier;
        this._nestedCollectionRoutesFunction = nestedCollectionRoutesFunction;
        this._identifierFunction = identifierFunction;
    }

    @Override
    public Try<SingleModel<T>> addCollectionItem(Body body) {
        return Try.fromOptional(this._collectionRoutesSupplier::get, ExceptionSupplierUtil.notFound(this._name)).mapOptional(CollectionRoutes::getCreateItemFunctionOptional, ExceptionSupplierUtil.notAllowed(HTTPMethod.POST, this._name)).map(function -> (Function)function.apply((Object)this._httpServletRequest)).flatMap(function -> (Try)function.apply(body));
    }

    @Override
    public Try<SingleModel<T>> addNestedCollectionItem(String id, String nestedName, Body body) {
        return Try.fromOptional(() -> this._nestedCollectionRoutesFunction.apply(nestedName), ExceptionSupplierUtil.notFound(this._name, nestedName)).mapOptional(NestedCollectionRoutes::getNestedCreateItemFunctionOptional).flatMap(function -> {
            Try<SingleModel<T>> singleModelTry = this.getCollectionItemSingleModelTry(id);
            return singleModelTry.mapOptional(this._getIdentifierFunction(nestedName)).flatMap(identifier -> (Try)((Function)((Function)function.apply((Object)this._httpServletRequest)).apply(identifier)).apply(body));
        }).mapFailMatching(NoSuchElementException.class, ExceptionSupplierUtil.notAllowed(HTTPMethod.POST, this._name, id, nestedName));
    }

    @Override
    public Response deleteCollectionItem(String id) throws Exception {
        ThrowableConsumer throwableConsumer = (ThrowableConsumer)Try.fromOptional(this._itemRoutesSupplier::get, ExceptionSupplierUtil.notFound(this._name)).mapOptional(ItemRoutes::getDeleteConsumerOptional, ExceptionSupplierUtil.notAllowed(HTTPMethod.DELETE, this._name, id)).map(function -> (ThrowableConsumer)function.apply((Object)this._httpServletRequest)).getUnchecked();
        Path path = new Path(this._name, id);
        throwableConsumer.accept(this._identifierFunction.apply((Object)path));
        return Response.noContent().build();
    }

    @Override
    public Try<SingleModel<T>> getCollectionItemSingleModelTry(String id) {
        return this._singleModelFunction.apply(id);
    }

    @Override
    public Try<Page<T>> getCollectionPageTry() {
        return Try.fromOptional(this._collectionRoutesSupplier::get, ExceptionSupplierUtil.notFound(this._name)).mapOptional(CollectionRoutes::getGetPageFunctionOptional, ExceptionSupplierUtil.notFound(this._name)).flatMap(function -> (Try)function.apply((Object)this._httpServletRequest));
    }

    @Override
    public Try<Page<T>> getNestedCollectionPageTry(String id, String nestedName) {
        return Try.fromOptional(() -> this._nestedCollectionRoutesFunction.apply(nestedName), ExceptionSupplierUtil.notFound(this._name, id, nestedName)).map(NestedCollectionRoutes::getNestedGetPageFunctionOptional).map(Optional::get).map(function -> (IdentifierFunction)function.apply((Object)this._httpServletRequest)).map(function -> (Function)function.apply((Object)new Path(this._name, id))).flatMap(pageFunction -> {
            Try<SingleModel<T>> parentSingleModelTry = this.getCollectionItemSingleModelTry(id);
            return parentSingleModelTry.map(this._getIdentifierFunction(nestedName)).map(optional -> optional.map(pageFunction));
        }).flatMap(Optional::get).mapFailMatching(NoSuchElementException.class, ExceptionSupplierUtil.notFound(id, nestedName));
    }

    @Override
    public Try<SingleModel<T>> updateCollectionItem(String id, Body body) {
        return Try.fromOptional(this._itemRoutesSupplier::get, ExceptionSupplierUtil.notFound(this._name, id)).mapOptional(ItemRoutes::getUpdateItemFunctionOptional, ExceptionSupplierUtil.notAllowed(HTTPMethod.PUT, this._name, id)).flatMap(function -> (Try)((Function)((Function)function.apply((Object)this._httpServletRequest)).compose(this._identifierFunction).apply(new Path(this._name, id))).apply(body));
    }

    private Predicate<RelatedCollection<?>> _getFilterRelatedCollectionPredicate(String nestedName) {
        return relatedCollection -> {
            Class relatedIdentifierClass = relatedCollection.getIdentifierClass();
            String className = relatedIdentifierClass.getName();
            return this._identifierClassFunction.apply(nestedName).map(Class::getName).map(className::equals).orElse(false);
        };
    }

    private ThrowableFunction<SingleModel<T>, Optional<Object>> _getIdentifierFunction(String nestedName) {
        Optional<Representor<T>> optional = this._representorSupplier.get();
        return parentSingleModel -> optional.map(Representor::getRelatedCollections).filter(stream -> stream.anyMatch(this._getFilterRelatedCollectionPredicate(nestedName))).flatMap(__ -> this._representorSupplier.get()).map(representor -> representor.getIdentifier(parentSingleModel.getModel()));
    }
}

