/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.endpoint;

import com.liferay.apio.architect.form.Form;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.impl.internal.endpoint.ExceptionSupplierUtil;
import com.liferay.apio.architect.routes.CollectionRoutes;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

public class FormEndpoint {
    private final Function<String, Optional<CollectionRoutes<Object, Object>>> _collectionRoutesFunction;
    private final Function<String, Optional<ItemRoutes<Object, Object>>> _itemRoutesFunction;
    private final BiFunction<String, String, Optional<NestedCollectionRoutes<Object, Object, Object>>> _nestedCollectionRoutesFunction;

    public FormEndpoint(Function<String, Optional<CollectionRoutes<Object, Object>>> collectionRoutesFunction, Function<String, Optional<ItemRoutes<Object, Object>>> itemRoutesFunction, BiFunction<String, String, Optional<NestedCollectionRoutes<Object, Object, Object>>> nestedCollectionRoutesFunction) {
        this._collectionRoutesFunction = collectionRoutesFunction;
        this._itemRoutesFunction = itemRoutesFunction;
        this._nestedCollectionRoutesFunction = nestedCollectionRoutesFunction;
    }

    @GET
    @Path(value="c/{name}")
    public Try<Form> creatorForm(@PathParam(value="name") String name) {
        return Try.fromOptional(() -> this._collectionRoutesFunction.apply(name).flatMap(CollectionRoutes::getFormOptional), ExceptionSupplierUtil.notFound(name));
    }

    @GET
    @Path(value="c/{name}/{nestedName}")
    public Try<Form> nestedCreatorForm(@PathParam(value="name") String name, @PathParam(value="nestedName") String nestedName) {
        return Try.fromOptional(() -> this._nestedCollectionRoutesFunction.apply(name, nestedName).flatMap(NestedCollectionRoutes::getFormOptional), ExceptionSupplierUtil.notFound(name, nestedName));
    }

    @GET
    @Path(value="u/{name}")
    public Try<Form> updaterForm(@PathParam(value="name") String name) {
        return Try.fromOptional(() -> this._itemRoutesFunction.apply(name).flatMap(ItemRoutes::getFormOptional), ExceptionSupplierUtil.notFound(name));
    }
}

