/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.impl.internal.endpoint;

import com.liferay.apio.architect.file.BinaryFile;
import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.impl.internal.endpoint.ExceptionSupplierUtil;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.single.model.SingleModel;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

public class BinaryEndpoint {
    private final Function<String, Optional<Representor<Object>>> _representorFunction;
    private final BiFunction<String, String, Try<SingleModel<Object>>> _singleModelFunction;

    public BinaryEndpoint(Function<String, Optional<Representor<Object>>> representorFunction, BiFunction<String, String, Try<SingleModel<Object>>> singleModelFunction) {
        this._representorFunction = representorFunction;
        this._singleModelFunction = singleModelFunction;
    }

    @GET
    @Path(value="{name}/{id}/{binaryId}")
    public Try<BinaryFile> getCollectionItemBinaryFileTry(@PathParam(value="name") String name, @PathParam(value="id") String id, @PathParam(value="binaryId") String binaryId) {
        return this._singleModelFunction.apply(name, id).map(SingleModel::getModel).mapOptional(model -> this._representorFunction.apply(name).flatMap(representor -> representor.getBinaryFunction(binaryId)).map(function -> (BinaryFile)function.apply(model)), ExceptionSupplierUtil.notFound(name, id, binaryId));
    }
}

