/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.exception.mapper.internal;

import com.liferay.apio.architect.error.APIError;
import com.liferay.apio.architect.exception.mapper.ExceptionMapper;
import com.liferay.apio.architect.exception.mapper.internal.WebApplicationExceptionMapperUtil;
import java.util.Optional;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;

@Component(service={ExceptionMapper.class})
public class ClientErrorExceptionMapper
implements ExceptionMapper<ClientErrorException> {
    public APIError map(ClientErrorException exception) {
        Response response = exception.getResponse();
        Response.StatusType statusType = response.getStatusInfo();
        String description = Optional.ofNullable(exception.getMessage()).filter(WebApplicationExceptionMapperUtil.isNotDefaultMessage(statusType)).orElse(null);
        return new APIError((Exception)exception, statusType.getReasonPhrase(), description, "client-error", statusType.getStatusCode());
    }
}

