/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.exception.mapper.internal;

import com.liferay.apio.architect.error.APIError;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public abstract class WebApplicationExceptionMapper {
    protected APIError convert(WebApplicationException exception) {
        String description = this._getDescription(exception.getMessage());
        return new APIError((Exception)exception, this.getTitle(), description, this.getType(), this.getStatusType().getStatusCode());
    }

    protected abstract Response.StatusType getStatusType();

    protected abstract String getTitle();

    protected abstract String getType();

    private String _getDescription(String message) {
        Response.StatusType statusType = this.getStatusType();
        String statusCode = String.valueOf(statusType.getStatusCode());
        String defaultMessage = String.join((CharSequence)" ", "HTTP", statusCode, statusType.getReasonPhrase());
        if (defaultMessage.equals(message)) {
            return null;
        }
        return message;
    }
}

