/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.apio.architect.functional;

import aQute.bnd.annotation.ConsumerType;
import com.liferay.apio.architect.consumer.throwable.ThrowableConsumer;
import com.liferay.apio.architect.exception.FalsePredicateException;
import com.liferay.apio.architect.function.throwable.ThrowableFunction;
import com.liferay.apio.architect.supplier.ThrowableSupplier;
import java.io.Closeable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

@ConsumerType
public abstract class Try<T> {
    public static <T> Try<T> fail(Exception exception) {
        return new Failure(exception);
    }

    public static <T> Try<T> fromFallible(ThrowableSupplier<T> throwableSupplier) {
        Objects.requireNonNull(throwableSupplier);
        try {
            return Try.success(throwableSupplier.get());
        }
        catch (Exception exception) {
            return Try.fail(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, S extends Closeable> Try<T> fromFallibleWithResources(ThrowableSupplier<S> throwableSupplier, ThrowableFunction<S, T> throwableFunction) {
        Objects.requireNonNull(throwableFunction);
        Objects.requireNonNull(throwableSupplier);
        try (Closeable s = (Closeable)throwableSupplier.get();){
            Try<T> try_ = Try.success(throwableFunction.apply(s));
            return try_;
        }
        catch (Exception exception) {
            return Try.fail(exception);
        }
    }

    public static <T> Try<T> fromOptional(ThrowableSupplier<Optional<T>> throwableSupplier, Supplier<? extends Exception> supplier) {
        Objects.requireNonNull(throwableSupplier);
        Objects.requireNonNull(supplier);
        return Try.fromFallible(throwableSupplier).map(Optional::get).mapFailMatching(NoSuchElementException.class, supplier);
    }

    public static <T> Try<T> success(T t) {
        return new Success(t);
    }

    public abstract Try<T> filter(Predicate<T> var1);

    public abstract <S> Try<S> flatMap(ThrowableFunction<? super T, Try<S>> var1);

    public abstract <S> S fold(Function<Exception, S> var1, ThrowableFunction<T, S> var2);

    public abstract T get() throws Exception;

    public abstract T getUnchecked();

    public abstract void ifFailure(Consumer<Exception> var1);

    public abstract void ifSuccess(Consumer<T> var1);

    public abstract boolean isFailure();

    public abstract boolean isSuccess();

    public abstract <S> Try<S> map(ThrowableFunction<? super T, ? extends S> var1);

    public abstract <S extends Exception> Try<T> mapFail(Function<Exception, S> var1);

    public abstract <S extends Exception, U extends Exception> Try<T> mapFailMatching(Class<U> var1, Supplier<S> var2);

    public <S> Try<S> mapOptional(ThrowableFunction<? super T, ? extends Optional<S>> throwableFunction) {
        Try tTry = this;
        return tTry.map(throwableFunction).map(Optional::get);
    }

    public <S> Try<S> mapOptional(ThrowableFunction<? super T, ? extends Optional<S>> throwableFunction, Supplier<? extends Exception> supplier) {
        Try tTry = this;
        return tTry.map(throwableFunction).map(Optional::get).mapFailMatching(NoSuchElementException.class, supplier);
    }

    public abstract T orElse(T var1);

    public abstract T orElseGet(Supplier<? extends T> var1);

    public abstract <S extends Throwable> T orElseThrow(Supplier<? extends S> var1) throws S;

    public abstract T recover(Function<? super Exception, T> var1);

    public abstract Try<T> recoverWith(ThrowableFunction<? super Exception, Try<T>> var1);

    public abstract Optional<T> toOptional();

    public abstract void voidFold(Consumer<Exception> var1, ThrowableConsumer<T> var2);

    private Try() {
    }

    public static class Success<T>
    extends Try<T> {
        private final T _value;

        @Override
        public Try<T> filter(Predicate<T> predicate) {
            Objects.requireNonNull(predicate);
            try {
                if (predicate.test(this._value)) {
                    return this;
                }
                return Try.fail(new FalsePredicateException(this._value));
            }
            catch (Exception e) {
                return Try.fail(new FalsePredicateException(this._value));
            }
        }

        @Override
        public <S> Try<S> flatMap(ThrowableFunction<? super T, Try<S>> function) {
            Objects.requireNonNull(function);
            try {
                return function.apply(this._value);
            }
            catch (Exception e) {
                return Try.fail(e);
            }
        }

        @Override
        public <S> S fold(Function<Exception, S> failureFunction, ThrowableFunction<T, S> successFunction) {
            Objects.requireNonNull(successFunction);
            Objects.requireNonNull(failureFunction);
            try {
                return successFunction.apply(this._value);
            }
            catch (Exception e) {
                return failureFunction.apply(e);
            }
        }

        @Override
        public T get() throws Exception {
            return this._value;
        }

        @Override
        public T getUnchecked() {
            return this._value;
        }

        public T getValue() {
            return this._value;
        }

        @Override
        public void ifFailure(Consumer<Exception> consumer) {
        }

        @Override
        public void ifSuccess(Consumer<T> consumer) {
            Objects.requireNonNull(consumer);
            consumer.accept(this._value);
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public <S> Try<S> map(ThrowableFunction<? super T, ? extends S> throwableFunction) {
            Objects.requireNonNull(throwableFunction);
            try {
                return Try.success(throwableFunction.apply(this._value));
            }
            catch (Exception e) {
                return Try.fail(e);
            }
        }

        @Override
        public <S extends Exception> Try<T> mapFail(Function<Exception, S> function) {
            Objects.requireNonNull(function);
            return this;
        }

        @Override
        public <S extends Exception, U extends Exception> Try<T> mapFailMatching(Class<U> exceptionClass, Supplier<S> supplier) {
            Objects.requireNonNull(supplier);
            return this;
        }

        @Override
        public T orElse(T other) {
            return this._value;
        }

        @Override
        public T orElseGet(Supplier<? extends T> supplier) {
            return this._value;
        }

        @Override
        public <S extends Throwable> T orElseThrow(Supplier<? extends S> supplier) throws S {
            return this._value;
        }

        @Override
        public T recover(Function<? super Exception, T> function) {
            Objects.requireNonNull(function);
            return this._value;
        }

        @Override
        public Try<T> recoverWith(ThrowableFunction<? super Exception, Try<T>> throwableFunction) {
            Objects.requireNonNull(throwableFunction);
            return this;
        }

        @Override
        public Optional<T> toOptional() {
            return Optional.ofNullable(this._value);
        }

        @Override
        public void voidFold(Consumer<Exception> failureConsumer, ThrowableConsumer<T> successConsumer) {
            Objects.requireNonNull(successConsumer);
            Objects.requireNonNull(failureConsumer);
            try {
                successConsumer.accept(this._value);
            }
            catch (Exception e) {
                failureConsumer.accept(e);
            }
        }

        private Success(T value) {
            this._value = value;
        }
    }

    public static class Failure<T>
    extends Try<T> {
        private final Exception _exception;

        @Override
        public Try<T> filter(Predicate<T> predicate) {
            return this;
        }

        @Override
        public <S> Try<S> flatMap(ThrowableFunction<? super T, Try<S>> throwableFunction) {
            Objects.requireNonNull(throwableFunction);
            return Try.fail(this._exception);
        }

        @Override
        public <S> S fold(Function<Exception, S> failureFunction, ThrowableFunction<T, S> successFunction) {
            Objects.requireNonNull(failureFunction);
            return failureFunction.apply(this._exception);
        }

        @Override
        public T get() throws Exception {
            throw this._exception;
        }

        public Exception getException() {
            return this._exception;
        }

        @Override
        public T getUnchecked() {
            if (this._exception instanceof RuntimeException) {
                throw (RuntimeException)this._exception;
            }
            throw new RuntimeException(this._exception);
        }

        @Override
        public void ifFailure(Consumer<Exception> consumer) {
            Objects.requireNonNull(consumer);
            consumer.accept(this._exception);
        }

        @Override
        public void ifSuccess(Consumer<T> consumer) {
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public <S> Try<S> map(ThrowableFunction<? super T, ? extends S> throwableFunction) {
            Objects.requireNonNull(throwableFunction);
            return Try.fail(this._exception);
        }

        @Override
        public <S extends Exception> Try<T> mapFail(Function<Exception, S> function) {
            Objects.requireNonNull(function);
            return Try.fail((Exception)function.apply(this._exception));
        }

        @Override
        public <S extends Exception, U extends Exception> Try<T> mapFailMatching(Class<U> exceptionClass, Supplier<S> supplier) {
            Objects.requireNonNull(supplier);
            Class<?> causeClass = this._exception.getClass();
            if (causeClass.equals(exceptionClass)) {
                return Try.fail((Exception)supplier.get());
            }
            return this;
        }

        @Override
        public T orElse(T other) {
            return other;
        }

        @Override
        public T orElseGet(Supplier<? extends T> supplier) {
            return supplier.get();
        }

        @Override
        public <S extends Throwable> T orElseThrow(Supplier<? extends S> supplier) throws S {
            throw (Throwable)supplier.get();
        }

        @Override
        public T recover(Function<? super Exception, T> function) {
            Objects.requireNonNull(function);
            return function.apply(this._exception);
        }

        @Override
        public Try<T> recoverWith(ThrowableFunction<? super Exception, Try<T>> throwableFunction) {
            Objects.requireNonNull(throwableFunction);
            try {
                return throwableFunction.apply(this._exception);
            }
            catch (Exception e) {
                return Try.fail(e);
            }
        }

        @Override
        public Optional<T> toOptional() {
            return Optional.empty();
        }

        @Override
        public void voidFold(Consumer<Exception> failureConsumer, ThrowableConsumer<T> successConsumer) {
            Objects.requireNonNull(failureConsumer);
            failureConsumer.accept(this._exception);
        }

        private Failure(Exception exception) {
            this._exception = exception;
        }
    }
}

