Liferay.Loader.define("@liferay/analytics-settings-web@5.0.46/js/components/table/utils.spec",["module","exports","require","../../utils/filter","../../utils/pagination","./utils"],(function(e,t,l){window;{var d=l("../../utils/filter"),i=l("../../utils/pagination"),a=l("./utils");function ownKeys(e,t){var l=Object.keys(e);if(Object.getOwnPropertySymbols){var d=Object.getOwnPropertySymbols(e);t&&(d=d.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),l.push.apply(l,d)}return l}function _objectSpread(e){for(var t=1;t<arguments.length;t++){var l=null!=arguments[t]?arguments[t]:{};t%2?ownKeys(Object(l),!0).forEach((function(t){_defineProperty(e,t,l[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(l)):ownKeys(Object(l)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(l,t))}))}return e}function _defineProperty(e,t,l){return t in e?Object.defineProperty(e,t,{value:l,enumerable:!0,configurable:!0,writable:!0}):e[t]=l,e}describe("serializeTableRequestParams",(()=>{it("returns a serialized table request params",(()=>{expect((0,a.serializeTableRequestParams)({filter:d.DEFAULT_FILTER,keywords:"",pagination:i.DEFAULT_PAGINATION})).toEqual("page=1&pageSize=20&sort=name:asc")})),it("returns a serialized table request params, changing page to 1 when has a keywords",(()=>{expect((0,a.serializeTableRequestParams)({filter:d.DEFAULT_FILTER,keywords:"Liferay DXP",pagination:_objectSpread(_objectSpread({},i.DEFAULT_PAGINATION),{},{page:10})})).toEqual("keywords=Liferay+DXP&page=1&pageSize=20&sort=name:asc")}))})),describe("getOrderBy",(()=>{it("returns the reverse OrderBy value ASC -> DESC",(()=>{expect((0,a.getOrderBy)({type:d.OrderBy.Asc,value:"name"})).toEqual(d.OrderBy.Desc)})),it("returns the reverse OrderBy value DESC -> ASC",(()=>{expect((0,a.getOrderBy)({type:d.OrderBy.Desc,value:"name"})).toEqual(d.OrderBy.Asc)}))})),describe("getOrderBySymbol",(()=>{it("returns OrderBy symbol based on value ASC",(()=>{expect((0,a.getOrderBySymbol)({type:d.OrderBy.Asc,value:"name"})).toEqual("order-list-up")})),it("returns OrderBy symbol based on value DESC",(()=>{expect((0,a.getOrderBySymbol)({type:d.OrderBy.Desc,value:"name"})).toEqual("order-list-down")}))})),describe("getResultsLanguage",(()=>{it("returns results language on singular",(()=>{expect((0,a.getResultsLanguage)(["Site A"])).toEqual("x-result-for")})),it("returns results language on plural",(()=>{expect((0,a.getResultsLanguage)(["Site A","Site B"])).toEqual("x-results-for")}))})),describe("getGlobalChecked",(()=>{it("returns true if all items have checked value as true",(()=>{expect((0,a.getGlobalChecked)({123:{checked:!0,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!0,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!0,columns:[{label:"Site C"}],disabled:!1,id:"789"}})).toBeTruthy()})),it("returns false if at least one item has value checked as false",(()=>{expect((0,a.getGlobalChecked)({123:{checked:!0,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!0,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!1,columns:[{label:"Site C"}],disabled:!1,id:"789"}})).toBeFalsy()})),it("returns false if there are no items",(()=>{expect((0,a.getGlobalChecked)({})).toBeFalsy()}))})),describe("updateFormattedItems",(()=>{it("returns items formatted with the checked value updated to true",(()=>{expect((0,a.updateFormattedItems)({123:{checked:!1,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!1,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!1,columns:[{label:"Site C"}],disabled:!1,id:"789"}},!0)).toEqual({123:{checked:!0,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!0,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!0,columns:[{label:"Site C"}],disabled:!1,id:"789"}})})),it("returns items formatted with the checked value updated to false",(()=>{expect((0,a.updateFormattedItems)({123:{checked:!0,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!0,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!0,columns:[{label:"Site C"}],disabled:!1,id:"789"}},!1)).toEqual({123:{checked:!1,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!1,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!1,columns:[{label:"Site C"}],disabled:!1,id:"789"}})})),it("returns formatted items without changing the checked value if the item is disabled",(()=>{expect((0,a.updateFormattedItems)({123:{checked:!0,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!0,columns:[{label:"Site B"}],disabled:!0,id:"456"},789:{checked:!0,columns:[{label:"Site C"}],disabled:!1,id:"789"}},!1)).toEqual({123:{checked:!1,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!0,columns:[{label:"Site B"}],disabled:!0,id:"456"},789:{checked:!1,columns:[{label:"Site C"}],disabled:!1,id:"789"}})}))})),describe("getFormattedItems",(()=>{it("returns formatted items",(()=>{expect((0,a.getFormattedItems)([{checked:!1,columns:[{label:"Site A"}],disabled:!1,id:"123"},{checked:!0,columns:[{label:"Site B"}],disabled:!0,id:"456"},{checked:!1,columns:[{label:"Site C"}],disabled:!1,id:"789"}])).toEqual({123:{checked:!1,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!0,columns:[{label:"Site B"}],disabled:!0,id:"456"},789:{checked:!1,columns:[{label:"Site C"}],disabled:!1,id:"789"}})})),it("returns empty formatted items",(()=>{expect((0,a.getFormattedItems)([])).toEqual({})}))})),describe("getIds",(()=>{it("returns ids with all checked items",(()=>{expect((0,a.getIds)({123:{checked:!0,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!0,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!0,columns:[{label:"Site C"}],disabled:!1,id:"789"}},[])).toEqual([123,456,789]),expect((0,a.getIds)({123:{checked:!1,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!1,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!0,columns:[{label:"Site C"}],disabled:!1,id:"789"}},[])).toEqual([789])})),it("returns ids with all checked items and old ones",(()=>{expect((0,a.getIds)({123:{checked:!0,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!0,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!0,columns:[{label:"Site C"}],disabled:!1,id:"789"}},[111,222,333])).toEqual([111,222,333,123,456,789]),expect((0,a.getIds)({123:{checked:!0,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!0,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!0,columns:[{label:"Site C"}],disabled:!1,id:"789"}},[111,222,333,123,456])).toEqual([111,222,333,123,456,789])})),it("returns ids with all checked items and not includes unchecked items",(()=>{expect((0,a.getIds)({123:{checked:!1,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!1,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!1,columns:[{label:"Site C"}],disabled:!1,id:"789"}},[])).toEqual([]),expect((0,a.getIds)({123:{checked:!1,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!0,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!1,columns:[{label:"Site C"}],disabled:!1,id:"789"}},[])).toEqual([456])})),it("returns ids with all checked items and remove unchecked items",(()=>{expect((0,a.getIds)({123:{checked:!1,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!1,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!1,columns:[{label:"Site C"}],disabled:!1,id:"789"}},[123,456,789])).toEqual([]),expect((0,a.getIds)({123:{checked:!1,columns:[{label:"Site A"}],disabled:!1,id:"123"},456:{checked:!1,columns:[{label:"Site B"}],disabled:!1,id:"456"},789:{checked:!1,columns:[{label:"Site C"}],disabled:!1,id:"789"}},[111,222,333])).toEqual([111,222,333])}))}))}}));
//# sourceMappingURL=utils.spec.js.map