/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.rest.internal.resource.v1_0;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.dto.v1_0.Channel;
import com.liferay.analytics.settings.rest.internal.client.AnalyticsCloudClient;
import com.liferay.analytics.settings.rest.internal.client.model.AnalyticsChannel;
import com.liferay.analytics.settings.rest.internal.client.model.AnalyticsDataSource;
import com.liferay.analytics.settings.rest.internal.client.pagination.Page;
import com.liferay.analytics.settings.rest.internal.dto.v1_0.converter.ChannelDTOConverter;
import com.liferay.analytics.settings.rest.internal.dto.v1_0.converter.ChannelDTOConverterContext;
import com.liferay.analytics.settings.rest.internal.manager.AnalyticsSettingsManager;
import com.liferay.analytics.settings.rest.internal.resource.v1_0.BaseChannelResourceImpl;
import com.liferay.analytics.settings.rest.resource.v1_0.ChannelResource;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/channel.properties"}, scope=ServiceScope.PROTOTYPE, service={ChannelResource.class})
public class ChannelResourceImpl
extends BaseChannelResourceImpl {
    @Reference
    protected DTOConverterRegistry dtoConverterRegistry;
    @Reference
    private AnalyticsCloudClient _analyticsCloudClient;
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    @Reference
    private ChannelDTOConverter _channelDTOConverter;
    private long _commerceChannelClassNameId;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    @Override
    public com.liferay.portal.vulcan.pagination.Page<Channel> getChannelsPage(String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        Page<AnalyticsChannel> analyticsChannelsPage = this._analyticsCloudClient.getAnalyticsChannelsPage(this.contextCompany.getCompanyId(), keywords, pagination.getPage() - 1, pagination.getPageSize(), sorts);
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        return com.liferay.portal.vulcan.pagination.Page.of(this.transform(analyticsChannelsPage.getItems(), analyticsChannel -> this._channelDTOConverter.toDTO((DTOConverterContext)new ChannelDTOConverterContext(analyticsChannel.getId(), this.contextAcceptLanguage.getPreferredLocale(), analyticsConfiguration.commerceSyncEnabledChannelIds()), (AnalyticsChannel)analyticsChannel)), (Pagination)pagination, (long)analyticsChannelsPage.getTotalCount());
    }

    @Override
    public Channel patchChannel(Channel channel) throws Exception {
        Object[] dataSources;
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        Object[] commerceSyncEnabledChannelIds = analyticsConfiguration.commerceSyncEnabledChannelIds();
        if (channel.getCommerceSyncEnabled() != null) {
            boolean commerceSyncEnabled = ArrayUtil.contains((Object[])commerceSyncEnabledChannelIds, (Object)channel.getChannelId());
            if (channel.getCommerceSyncEnabled().booleanValue() && !commerceSyncEnabled) {
                commerceSyncEnabledChannelIds = (String[])ArrayUtil.append((Object[])commerceSyncEnabledChannelIds, (Object)channel.getChannelId());
                this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), HashMapBuilder.put((Object)"commerceSyncEnabledChannelIds", (Object)commerceSyncEnabledChannelIds).build());
            }
            if (!channel.getCommerceSyncEnabled().booleanValue() && commerceSyncEnabled) {
                commerceSyncEnabledChannelIds = ArrayUtil.remove((String[])commerceSyncEnabledChannelIds, (String)channel.getChannelId());
                this._analyticsSettingsManager.updateCompanyConfiguration(this.contextCompany.getCompanyId(), HashMapBuilder.put((Object)"commerceSyncEnabledChannelIds", (Object)commerceSyncEnabledChannelIds).build());
            }
        }
        if (ArrayUtil.isEmpty((Object[])(dataSources = channel.getDataSources()))) {
            return this._channelDTOConverter.toDTO((DTOConverterContext)new ChannelDTOConverterContext(channel.getChannelId(), this.contextAcceptLanguage.getPreferredLocale(), (String[])commerceSyncEnabledChannelIds), this._analyticsCloudClient.updateAnalyticsChannel(channel.getChannelId(), (Long[])Stream.of(analyticsConfiguration.syncedCommerceChannelIds()).map(Long::valueOf).toArray(Long[]::new), this.contextUser.getCompanyId(), analyticsConfiguration.liferayAnalyticsDataSourceId(), this.contextAcceptLanguage.getPreferredLocale(), (Long[])Stream.of(analyticsConfiguration.syncedGroupIds()).map(Long::valueOf).toArray(Long[]::new)));
        }
        if (dataSources.length > 1) {
            throw new PortalException("Unable to update multiple data sources");
        }
        Object dataSource = dataSources[0];
        AnalyticsChannel analyticsChannel = this._analyticsCloudClient.updateAnalyticsChannel(channel.getChannelId(), dataSource.getCommerceChannelIds(), this.contextUser.getCompanyId(), dataSource.getDataSourceId(), this.contextAcceptLanguage.getPreferredLocale(), dataSource.getSiteIds());
        AnalyticsDataSource analyticsDataSource = this._getAnalyticsDataSource(GetterUtil.getLong((String)dataSource.getDataSourceId()), analyticsChannel.getAnalyticsDataSources());
        this._analyticsCloudClient.updateAnalyticsDataSourceDetails(null, this.contextCompany.getCompanyId(), ArrayUtil.isNotEmpty((Object[])analyticsDataSource.getCommerceChannelIds()), null, ArrayUtil.isNotEmpty((Object[])analyticsDataSource.getSiteIds()));
        this._updateCommerceChannelGroups(analyticsConfiguration.syncedCommerceChannelIds(), channel.getChannelId(), this.contextCompany.getCompanyId(), analyticsDataSource.getCommerceChannelIds());
        this._updateGroups(analyticsConfiguration.syncedGroupIds(), channel.getChannelId(), analyticsDataSource.getSiteIds());
        this._analyticsSettingsManager.updateCompanyConfiguration(this.contextUser.getCompanyId(), HashMapBuilder.put((Object)"syncedCommerceChannelIds", (Object)analyticsDataSource.getCommerceChannelIds()).put((Object)"syncedGroupIds", (Object)analyticsDataSource.getSiteIds()).build());
        return this._channelDTOConverter.toDTO((DTOConverterContext)new ChannelDTOConverterContext(channel.getChannelId(), this.contextAcceptLanguage.getPreferredLocale(), (String[])commerceSyncEnabledChannelIds), analyticsChannel);
    }

    @Override
    public Channel postChannel(Channel channel) throws Exception {
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(this.contextCompany.getCompanyId());
        return this._channelDTOConverter.toDTO((DTOConverterContext)new ChannelDTOConverterContext(channel.getChannelId(), this.contextAcceptLanguage.getPreferredLocale(), analyticsConfiguration.commerceSyncEnabledChannelIds()), this._analyticsCloudClient.addAnalyticsChannel(this.contextCompany.getCompanyId(), channel.getName()));
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._commerceChannelClassNameId = this._portal.getClassNameId("com.liferay.commerce.product.model.CommerceChannel");
    }

    private AnalyticsDataSource _getAnalyticsDataSource(long analyticsDataSourceId, AnalyticsDataSource[] analyticsDataSources) {
        for (AnalyticsDataSource analyticsDataSource : analyticsDataSources) {
            if (analyticsDataSource.getId() != analyticsDataSourceId) continue;
            return analyticsDataSource;
        }
        throw new RuntimeException("Unable to get analytics data source");
    }

    private void _updateCommerceChannelGroups(String[] analyticsConfigurationCommerceChannelIds, String channelId, long companyId, Long[] dataSourceCommerceChannelIds) throws Exception {
        this._updateTypeSetting(channelId, commerceChannelId -> this._groupLocalService.fetchGroup(companyId, this._commerceChannelClassNameId, commerceChannelId.longValue()), ArrayUtil.filter((Object[])dataSourceCommerceChannelIds, commerceChannelId -> !ArrayUtil.contains((Object[])analyticsConfigurationCommerceChannelIds, (Object)String.valueOf(commerceChannelId))), false);
        this._updateTypeSetting(channelId, commerceChannelId -> this._groupLocalService.fetchGroup(companyId, this._commerceChannelClassNameId, commerceChannelId.longValue()), ArrayUtil.filter((Object[])analyticsConfigurationCommerceChannelIds, commerceChannelId -> !ArrayUtil.contains((Object[])dataSourceCommerceChannelIds, (Object)Long.valueOf(commerceChannelId))), true);
    }

    private void _updateGroups(String[] analyticsConfigurationGroupIds, String channelId, Long[] dataSourceGroupIds) throws Exception {
        this._updateTypeSetting(channelId, groupId -> this._groupLocalService.fetchGroup(groupId.longValue()), ArrayUtil.filter((Object[])dataSourceGroupIds, groupId -> !ArrayUtil.contains((Object[])analyticsConfigurationGroupIds, (Object)String.valueOf(groupId))), false);
        this._updateTypeSetting(channelId, groupId -> this._groupLocalService.fetchGroup(groupId.longValue()), ArrayUtil.filter((Object[])analyticsConfigurationGroupIds, groupId -> !ArrayUtil.contains((Object[])dataSourceGroupIds, (Object)Long.valueOf(groupId))), true);
    }

    private <T> void _updateTypeSetting(String channelId, Function<Long, Group> fetchGroupFunction, T[] groupIds, boolean remove) throws Exception {
        for (T groupId : groupIds) {
            Group group = fetchGroupFunction.apply(GetterUtil.getLong(groupId));
            if (group == null) continue;
            UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
            if (remove) {
                String analyticsChannelId = (String)typeSettingsUnicodeProperties.get((Object)"analyticsChannelId");
                if (!channelId.equals(analyticsChannelId)) continue;
                typeSettingsUnicodeProperties.remove((Object)"analyticsChannelId");
            } else {
                typeSettingsUnicodeProperties.setProperty("analyticsChannelId", channelId);
            }
            this._groupLocalService.updateGroup(group);
        }
    }
}

