/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.internal.model.listener;

import com.liferay.analytics.batch.exportimport.model.listener.BaseAnalyticsDXPEntityModelListener;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;

@Component(service={ModelListener.class})
public class UserModelListener
extends BaseAnalyticsDXPEntityModelListener<User> {
    private static final Log _log = LogFactoryUtil.getLog(UserModelListener.class);

    protected boolean isTracked(User user) {
        if (user == null || Objects.equals(user.getScreenName(), "analytics.administrator") || Objects.equals(user.getStatus(), 5)) {
            return false;
        }
        AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationRegistry.getAnalyticsConfiguration(user.getCompanyId());
        if (analyticsConfiguration.syncAllContacts()) {
            return true;
        }
        long[] organizationIds = null;
        try {
            organizationIds = user.getOrganizationIds();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
        for (long organizationId : organizationIds) {
            if (!ArrayUtil.contains((Object[])analyticsConfiguration.syncedOrganizationIds(), (Object)String.valueOf(organizationId))) continue;
            return true;
        }
        for (long userGroupId : user.getUserGroupIds()) {
            if (!ArrayUtil.contains((Object[])analyticsConfiguration.syncedUserGroupIds(), (Object)String.valueOf(userGroupId))) continue;
            return true;
        }
        return false;
    }
}

