/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.internal.model.listener;

import com.liferay.analytics.batch.exportimport.model.listener.BaseAnalyticsDXPEntityModelListener;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ExpandoColumnModelListener
extends BaseAnalyticsDXPEntityModelListener<ExpandoColumn> {
    private static final Log _log = LogFactoryUtil.getLog(ExpandoColumnModelListener.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;

    protected boolean isTracked(ExpandoColumn expandoColumn) {
        if (this._isCustomField(Organization.class.getName(), expandoColumn.getTableId())) {
            return true;
        }
        if (this._isCustomField(User.class.getName(), expandoColumn.getTableId())) {
            AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationRegistry.getAnalyticsConfiguration(expandoColumn.getCompanyId());
            if (ArrayUtil.isEmpty((Object[])analyticsConfiguration.syncedUserFieldNames())) {
                return false;
            }
            for (String syncedUserFieldName : analyticsConfiguration.syncedUserFieldNames()) {
                if (!Objects.equals(expandoColumn.getName(), syncedUserFieldName)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean _isCustomField(String className, long tableId) {
        block3: {
            long classNameId = this._classNameLocalService.getClassNameId(className);
            try {
                ExpandoTable expandoTable = this._expandoTableLocalService.getTable(tableId);
                if (Objects.equals("CUSTOM_FIELDS", expandoTable.getName()) && expandoTable.getClassNameId() == classNameId) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to get expando table " + tableId), (Throwable)exception);
            }
        }
        return false;
    }
}

