/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.internal.messaging;

import com.liferay.analytics.message.sender.client.AnalyticsMessageSenderClient;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationTracker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CheckAnalyticsConnectionsMessageListener.class})
public class CheckAnalyticsConnectionsMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(CheckAnalyticsConnectionsMessageListener.class);
    @Reference
    private AnalyticsConfigurationTracker _analyticsConfigurationTracker;
    @Reference
    private AnalyticsMessageSenderClient _analyticsMessageSenderClient;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    @Modified
    protected void activate() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, 15, TimeUnit.MINUTE);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        Map analyticsConfigurations = this._analyticsConfigurationTracker.getAnalyticsConfigurations();
        if (analyticsConfigurations.isEmpty()) {
            return;
        }
        for (Map.Entry analyticsConfigurationEntry : analyticsConfigurations.entrySet()) {
            try {
                this._analyticsMessageSenderClient.validateConnection(((Long)analyticsConfigurationEntry.getKey()).longValue());
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to connect Analytics Cloud for company " + analyticsConfigurationEntry.getKey()), (Throwable)exception);
                throw exception;
            }
        }
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }
}

