/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.analytics.message.storage.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the AnalyticsAssociation service. Represents a row in the &quot;AnalyticsAssociation&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.analytics.message.storage.model.impl.AnalyticsAssociationModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.analytics.message.storage.model.impl.AnalyticsAssociationImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AnalyticsAssociation
 * @generated
 */
@ProviderType
public interface AnalyticsAssociationModel
	extends BaseModel<AnalyticsAssociation>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a analytics association model instance should use the {@link AnalyticsAssociation} interface instead.
	 */

	/**
	 * Returns the primary key of this analytics association.
	 *
	 * @return the primary key of this analytics association
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this analytics association.
	 *
	 * @param primaryKey the primary key of this analytics association
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this analytics association.
	 *
	 * @return the mvcc version of this analytics association
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this analytics association.
	 *
	 * @param mvccVersion the mvcc version of this analytics association
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the analytics association ID of this analytics association.
	 *
	 * @return the analytics association ID of this analytics association
	 */
	public long getAnalyticsAssociationId();

	/**
	 * Sets the analytics association ID of this analytics association.
	 *
	 * @param analyticsAssociationId the analytics association ID of this analytics association
	 */
	public void setAnalyticsAssociationId(long analyticsAssociationId);

	/**
	 * Returns the company ID of this analytics association.
	 *
	 * @return the company ID of this analytics association
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this analytics association.
	 *
	 * @param companyId the company ID of this analytics association
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the create date of this analytics association.
	 *
	 * @return the create date of this analytics association
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this analytics association.
	 *
	 * @param createDate the create date of this analytics association
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this analytics association.
	 *
	 * @return the modified date of this analytics association
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this analytics association.
	 *
	 * @param modifiedDate the modified date of this analytics association
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the user ID of this analytics association.
	 *
	 * @return the user ID of this analytics association
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this analytics association.
	 *
	 * @param userId the user ID of this analytics association
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this analytics association.
	 *
	 * @return the user uuid of this analytics association
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this analytics association.
	 *
	 * @param userUuid the user uuid of this analytics association
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the association class name of this analytics association.
	 *
	 * @return the association class name of this analytics association
	 */
	@AutoEscape
	public String getAssociationClassName();

	/**
	 * Sets the association class name of this analytics association.
	 *
	 * @param associationClassName the association class name of this analytics association
	 */
	public void setAssociationClassName(String associationClassName);

	/**
	 * Returns the association class pk of this analytics association.
	 *
	 * @return the association class pk of this analytics association
	 */
	public long getAssociationClassPK();

	/**
	 * Sets the association class pk of this analytics association.
	 *
	 * @param associationClassPK the association class pk of this analytics association
	 */
	public void setAssociationClassPK(long associationClassPK);

	/**
	 * Returns the class name of this analytics association.
	 *
	 * @return the class name of this analytics association
	 */
	@AutoEscape
	public String getClassName();

	/**
	 * Sets the class name of this analytics association.
	 *
	 * @param className the class name of this analytics association
	 */
	public void setClassName(String className);

	/**
	 * Returns the class pk of this analytics association.
	 *
	 * @return the class pk of this analytics association
	 */
	public long getClassPK();

	/**
	 * Sets the class pk of this analytics association.
	 *
	 * @param classPK the class pk of this analytics association
	 */
	public void setClassPK(long classPK);

	@Override
	public AnalyticsAssociation cloneWithOriginalValues();

}