/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal.messaging;

import com.liferay.analytics.message.sender.client.AnalyticsMessageSenderClient;
import com.liferay.analytics.message.storage.model.AnalyticsMessage;
import com.liferay.analytics.message.storage.service.AnalyticsMessageLocalService;
import com.liferay.petra.io.StreamUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AnalyticsMessagesHelper.class})
public class AnalyticsMessagesHelper {
    private static final int _BATCH_SIZE = 100;
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsMessagesHelper.class);
    @Reference
    private AnalyticsMessageLocalService _analyticsMessageLocalService;
    @Reference
    private AnalyticsMessageSenderClient _analyticsMessageSenderClient;
    @Reference
    private JSONFactory _jsonFactory;

    public void send(long companyId) throws Exception {
        while (true) {
            List analyticsMessages;
            if ((analyticsMessages = this._analyticsMessageLocalService.getAnalyticsMessages(companyId, 0, 100)).isEmpty()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Finished processing analytics messages");
                }
                return;
            }
            JSONArray jsonArray = this._jsonFactory.createJSONArray();
            for (AnalyticsMessage analyticsMessage : analyticsMessages) {
                String json = new String(StreamUtil.toByteArray((InputStream)this._analyticsMessageLocalService.openBodyInputStream(analyticsMessage.getAnalyticsMessageId())), StandardCharsets.UTF_8);
                jsonArray.put(this._jsonFactory.createJSONObject(json));
            }
            try {
                this._analyticsMessageSenderClient.send(jsonArray.toString(), companyId);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Sent " + jsonArray.length() + " analytics messages"));
                }
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to send analytics messages for company " + companyId), (Throwable)exception);
            }
            this._analyticsMessageLocalService.deleteAnalyticsMessages(analyticsMessages);
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)("Deleted " + analyticsMessages.size() + " analytics messages"));
        }
    }
}

