/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.internal;

import com.liferay.analytics.message.sender.client.AnalyticsMessageSenderClient;
import com.liferay.analytics.message.sender.internal.BaseAnalyticsClientImpl;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Validator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={AnalyticsMessageSenderClient.class})
public class AnalyticsMessageSenderClientImpl
extends BaseAnalyticsClientImpl
implements AnalyticsMessageSenderClient {
    public Object send(String body, long companyId) throws Exception {
        if (!this.isEnabled(companyId)) {
            return null;
        }
        AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationTracker.getAnalyticsConfiguration(companyId);
        HttpUriRequest httpUriRequest = this._buildHttpUriRequest(body, analyticsConfiguration.liferayAnalyticsDataSourceId(), analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature(), "POST", analyticsConfiguration.liferayAnalyticsEndpointURL() + "/dxp-entities");
        return this._execute(companyId, httpUriRequest);
    }

    public void validateConnection(long companyId) throws Exception {
        if (!this.isEnabled(companyId)) {
            return;
        }
        AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationTracker.getAnalyticsConfiguration(companyId);
        HttpUriRequest httpUriRequest = this._buildHttpUriRequest(null, analyticsConfiguration.liferayAnalyticsDataSourceId(), analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature(), "GET", analyticsConfiguration.liferayAnalyticsEndpointURL() + "/api/1.0/data-sources/" + analyticsConfiguration.liferayAnalyticsDataSourceId());
        this._execute(companyId, httpUriRequest);
    }

    private HttpUriRequest _buildHttpUriRequest(String body, String dataSourceId, String faroBackendSecuritySignature, String method, String url) throws Exception {
        HttpGet httpUriRequest = null;
        if (method.equals("GET")) {
            httpUriRequest = new HttpGet(url);
        } else if (method.equals("POST")) {
            HttpPost httpPost = new HttpPost(url);
            if (Validator.isNotNull((String)body)) {
                httpPost.setEntity((HttpEntity)new StringEntity(body, StandardCharsets.UTF_8));
            }
            httpUriRequest = httpPost;
        }
        if (httpUriRequest != null) {
            httpUriRequest.setHeader("Content-Type", "application/json");
            httpUriRequest.setHeader("OSB-Asah-Data-Source-ID", dataSourceId);
            httpUriRequest.setHeader("OSB-Asah-Faro-Backend-Security-Signature", faroBackendSecuritySignature);
        }
        return httpUriRequest;
    }

    private CloseableHttpResponse _execute(long companyId, HttpUriRequest httpUriRequest) throws Exception {
        try (CloseableHttpClient closeableHttpClient = this.getCloseableHttpClient();){
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpUriRequest);
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 403) {
                CloseableHttpResponse closeableHttpResponse2 = closeableHttpResponse;
                return closeableHttpResponse2;
            }
            JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject((String)EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (Charset)Charset.defaultCharset()));
            this.processInvalidTokenMessage(companyId, responseJSONObject.getString("message"));
            CloseableHttpResponse closeableHttpResponse3 = closeableHttpResponse;
            return closeableHttpResponse3;
        }
    }
}

