/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.message.sender.model.listener;

import com.liferay.analytics.message.sender.model.AnalyticsMessage;
import com.liferay.analytics.message.sender.model.listener.EntityModelListener;
import com.liferay.analytics.message.sender.util.AnalyticsExpandoBridgeUtil;
import com.liferay.analytics.message.storage.service.AnalyticsMessageLocalService;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationTracker;
import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.TreeModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.component.annotations.Reference;

@ProviderType
public abstract class BaseEntityModelListener<T extends BaseModel<T>>
extends BaseModelListener<T>
implements EntityModelListener<T> {
    @Reference
    protected AnalyticsConfigurationTracker analyticsConfigurationTracker;
    @Reference
    protected AnalyticsMessageLocalService analyticsMessageLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected CompanyService companyService;
    @Reference
    protected ConfigurationProvider configurationProvider;
    @Reference
    protected ExpandoTableLocalService expandoTableLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseEntityModelListener.class);
    private static final List<String> _organizationAttributeNames = Arrays.asList("expando", "modifiedDate", "name", "parentOrganizationId", "treePath", "type");
    private static final List<String> _userAttributeNames = Arrays.asList("agreedToTermsOfUse", "comments", "companyId", "contactId", "createDate", "defaultUser", "emailAddress", "emailAddressVerified", "expando", "externalReferenceCode", "facebookId", "firstName", "googleUserId", "greeting", "jobTitle", "languageId", "lastName", "ldapServerId", "memberships", "middleName", "modifiedDate", "openId", "portraitId", "screenName", "status", "timeZoneId", "uuid");

    @Override
    public void addAnalyticsMessage(String eventType, List<String> includeAttributeNames, T model) {
        block4: {
            Contact contact;
            String modelClassName = model.getModelClassName();
            if (modelClassName.equals(Contact.class.getName()) ? this.isUserExcluded(this.userLocalService.fetchUser((contact = (Contact)model).getClassPK())) : (modelClassName.equals(User.class.getName()) ? this.isUserExcluded((User)model) : this.isExcluded(model))) {
                return;
            }
            JSONObject jsonObject = this.serialize((BaseModel<?>)model, includeAttributeNames);
            ShardedModel shardedModel = (ShardedModel)model;
            if (modelClassName.equals(ExpandoRow.class.getName())) {
                ExpandoRow expandoRow = (ExpandoRow)model;
                modelClassName = this.isCustomField(Organization.class.getName(), expandoRow.getTableId()) ? Organization.class.getName() : User.class.getName();
            }
            try {
                AnalyticsMessage.Builder analyticsMessageBuilder = AnalyticsMessage.builder(modelClassName);
                analyticsMessageBuilder.action(eventType);
                analyticsMessageBuilder.object(jsonObject);
                String analyticsMessageJSON = analyticsMessageBuilder.buildJSONString();
                this.analyticsMessageLocalService.addAnalyticsMessage(shardedModel.getCompanyId(), this.userLocalService.getDefaultUserId(shardedModel.getCompanyId()), analyticsMessageJSON.getBytes(Charset.defaultCharset()));
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to add analytics message " + jsonObject.toString()), (Throwable)exception);
            }
        }
    }

    @Override
    public long[] getMembershipIds(User user) throws Exception {
        return new long[0];
    }

    @Override
    public String getModelClassName() {
        return null;
    }

    public void onAfterAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LRAC-10632")) || !this.analyticsConfigurationTracker.isActive()) {
            return;
        }
        this._onAfterUpdateAssociation(classPK, associationClassName, associationClassPK, "addAssociation");
    }

    public void onAfterCreate(T model) throws ModelListenerException {
        if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LRAC-10632")) || !this.analyticsConfigurationTracker.isActive()) {
            return;
        }
        ShardedModel shardedModel = (ShardedModel)model;
        this.addAnalyticsMessage("add", this.getAttributeNames(shardedModel.getCompanyId()), model);
    }

    public void onAfterRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LRAC-10632")) || !this.analyticsConfigurationTracker.isActive()) {
            return;
        }
        this._onAfterUpdateAssociation(classPK, associationClassName, associationClassPK, "deleteAssociation");
    }

    public void onBeforeRemove(T model) throws ModelListenerException {
        if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LRAC-10632")) || !this.analyticsConfigurationTracker.isActive()) {
            return;
        }
        this.addAnalyticsMessage("delete", new ArrayList<String>(), model);
    }

    public void onBeforeUpdate(T originalModel, T model) throws ModelListenerException {
        if (GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LRAC-10632")) || !this.analyticsConfigurationTracker.isActive()) {
            return;
        }
        ShardedModel shardedModel = (ShardedModel)model;
        try {
            List<String> modifiedAttributeNames = this._getModifiedAttributeNames(this.getAttributeNames(shardedModel.getCompanyId()), model, this.getModel((Long)model.getPrimaryKeyObj()));
            if (modifiedAttributeNames.isEmpty()) {
                return;
            }
            this.addAnalyticsMessage("update", this.getAttributeNames(shardedModel.getCompanyId()), model);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    @Override
    public void syncAll(long companyId) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        if (actionableDynamicQuery == null) {
            return;
        }
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(model -> this.addAnalyticsMessage("add", this.getAttributeNames(companyId), model));
        actionableDynamicQuery.performActions();
    }

    protected ActionableDynamicQuery getActionableDynamicQuery() {
        return null;
    }

    protected abstract T getModel(long var1) throws Exception;

    protected List<String> getOrganizationAttributeNames() {
        return _organizationAttributeNames;
    }

    protected abstract String getPrimaryKeyName();

    @Deprecated
    protected List<String> getUserAttributeNames() {
        return null;
    }

    protected List<String> getUserAttributeNames(long companyId) {
        AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationTracker.getAnalyticsConfiguration(companyId);
        if (ArrayUtil.isEmpty((Object[])analyticsConfiguration.syncedUserFieldNames())) {
            return _userAttributeNames;
        }
        ArrayList<String> attributeNames = new ArrayList<String>();
        attributeNames.add("expando");
        attributeNames.add("memberships");
        for (String name : _userAttributeNames) {
            if (!ArrayUtil.contains((Object[])analyticsConfiguration.syncedUserFieldNames(), (Object)name)) continue;
            attributeNames.add(name);
        }
        return attributeNames;
    }

    protected boolean isCustomField(String className, long tableId) {
        block3: {
            long classNameId = this.classNameLocalService.getClassNameId(className);
            try {
                ExpandoTable expandoTable = this.expandoTableLocalService.getTable(tableId);
                if (Objects.equals("CUSTOM_FIELDS", expandoTable.getName()) && expandoTable.getClassNameId() == classNameId) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to get expando table " + tableId), (Throwable)exception);
            }
        }
        return false;
    }

    protected boolean isExcluded(T model) {
        ShardedModel shardedModel = (ShardedModel)model;
        Dictionary analyticsConfigurationProperties = this.analyticsConfigurationTracker.getAnalyticsConfigurationProperties(shardedModel.getCompanyId());
        return analyticsConfigurationProperties == null;
    }

    protected boolean isUserExcluded(User user) {
        if (user == null || Objects.equals(user.getScreenName(), "analytics.administrator") || Objects.equals(user.getStatus(), 5)) {
            return true;
        }
        AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationTracker.getAnalyticsConfiguration(user.getCompanyId());
        if (analyticsConfiguration.syncAllContacts()) {
            return false;
        }
        long[] organizationIds = null;
        try {
            organizationIds = user.getOrganizationIds();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return true;
        }
        for (long organizationId : organizationIds) {
            if (!ArrayUtil.contains((Object[])analyticsConfiguration.syncedOrganizationIds(), (Object)String.valueOf(organizationId))) continue;
            return false;
        }
        for (long userGroupId : user.getUserGroupIds()) {
            if (!ArrayUtil.contains((Object[])analyticsConfiguration.syncedUserGroupIds(), (Object)String.valueOf(userGroupId))) continue;
            return false;
        }
        return true;
    }

    protected JSONObject serialize(BaseModel<?> baseModel, List<String> includeAttributeNames) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Map modelAttributes = baseModel.getModelAttributes();
        for (String includeAttributeName : includeAttributeNames) {
            if (includeAttributeName.equals("associations") && StringUtil.equals((String)baseModel.getModelClassName(), (String)User.class.getName())) {
                long[] membershipIds;
                HashMap<String, long[]> memberships = new HashMap<String, long[]>();
                User user = (User)baseModel;
                try {
                    List groups = user.getSiteGroups();
                    Stream stream = groups.stream();
                    long[] membershipIds2 = stream.mapToLong(GroupModel::getGroupId).toArray();
                    if (membershipIds2.length != 0) {
                        memberships.put(Group.class.getName(), membershipIds2);
                    }
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
                try {
                    membershipIds = user.getOrganizationIds();
                    if (membershipIds.length != 0) {
                        memberships.put(Organization.class.getName(), membershipIds);
                    }
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
                membershipIds = user.getRoleIds();
                if (membershipIds.length != 0) {
                    memberships.put(Role.class.getName(), membershipIds);
                }
                if ((membershipIds = user.getTeamIds()).length != 0) {
                    memberships.put(Team.class.getName(), membershipIds);
                }
                if ((membershipIds = user.getUserGroupIds()).length != 0) {
                    memberships.put(UserGroup.class.getName(), membershipIds);
                }
                jsonObject.put("memberships", memberships);
                continue;
            }
            if (includeAttributeName.equals("expando")) {
                jsonObject.put("expando", () -> {
                    if (StringUtil.equals((String)baseModel.getModelClassName(), (String)User.class.getName())) {
                        ShardedModel shardedModel = (ShardedModel)baseModel;
                        AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationTracker.getAnalyticsConfiguration(shardedModel.getCompanyId());
                        return AnalyticsExpandoBridgeUtil.getAttributes(baseModel.getExpandoBridge(), ListUtil.fromArray((Object[])analyticsConfiguration.syncedUserFieldNames()));
                    }
                    return AnalyticsExpandoBridgeUtil.getAttributes(baseModel.getExpandoBridge(), null);
                });
                continue;
            }
            if (includeAttributeName.equals("treePath") && baseModel instanceof TreeModel) {
                TreeModel treeModel = (TreeModel)baseModel;
                String treePath = treeModel.getTreePath();
                String[] ids = StringUtil.split((String)treePath.substring(1), (String)"/");
                jsonObject.put("nameTreePath", this._buildNameTreePath(ids)).put("parentName", () -> {
                    if (ids.length > 1) {
                        return this._getName(GetterUtil.getLong((String)ids[ids.length - 2]));
                    }
                    return null;
                });
                continue;
            }
            Object value = modelAttributes.get(includeAttributeName);
            if (value instanceof Date) {
                Date date = (Date)value;
                jsonObject.put(includeAttributeName, date.getTime());
                continue;
            }
            if (includeAttributeName.equals("name")) {
                value = this._getName(String.valueOf(value));
            }
            jsonObject.put(includeAttributeName, value);
        }
        return jsonObject.put(this.getPrimaryKeyName(), () -> {
            if (modelAttributes.containsKey(this.getPrimaryKeyName())) {
                return baseModel.getPrimaryKeyObj();
            }
            return null;
        });
    }

    protected void updateConfigurationProperties(long companyId, String configurationPropertyName, String modelId, String preferencePropertyName) {
        block8: {
            Object[] modelIds;
            Dictionary configurationProperties;
            block7: {
                configurationProperties = this.analyticsConfigurationTracker.getAnalyticsConfigurationProperties(companyId);
                if (configurationProperties == null) {
                    return;
                }
                modelIds = (String[])configurationProperties.get(configurationPropertyName);
                if (!ArrayUtil.contains((Object[])modelIds, (Object)modelId)) {
                    return;
                }
                modelIds = ArrayUtil.remove((String[])modelIds, (String)modelId);
                if (Validator.isNotNull((String)preferencePropertyName)) {
                    try {
                        this.companyService.updatePreferences(companyId, UnicodePropertiesBuilder.create((boolean)true).put(preferencePropertyName, StringUtil.merge((Object[])modelIds, (String)",")).build());
                    }
                    catch (Exception exception) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn((Object)("Unable to update preferences for company " + companyId), (Throwable)exception);
                    }
                }
            }
            configurationProperties.put(configurationPropertyName, modelIds);
            try {
                this.configurationProvider.saveCompanyConfiguration(AnalyticsConfiguration.class, companyId, configurationProperties);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Unable to update configuration for company " + companyId), (Throwable)exception);
            }
        }
    }

    private String _buildNameTreePath(String[] ids) {
        int size = ids.length;
        StringBundler sb = new StringBundler(ids.length * 4 + 1);
        sb.append(this._getName(GetterUtil.getLong((String)ids[0])));
        for (int i = 1; i < size; ++i) {
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
            sb.append(this._getName(GetterUtil.getLong((String)ids[i])));
        }
        return sb.toString();
    }

    private List<String> _getModifiedAttributeNames(List<String> attributeNames, T model, T originalModel) {
        ArrayList<String> modifiedAttributeNames = new ArrayList<String>();
        for (String attributeName : attributeNames) {
            String originalValue;
            String value;
            if (attributeName.equalsIgnoreCase("expando") || attributeName.equalsIgnoreCase("memberships") || attributeName.equalsIgnoreCase("modifiedDate") && !Objects.equals(model.getModelClassName(), ExpandoRow.class.getName()) || Objects.equals(value = String.valueOf(BeanPropertiesUtil.getObject(model, (String)attributeName)), originalValue = String.valueOf(BeanPropertiesUtil.getObject(originalModel, (String)attributeName)))) continue;
            modifiedAttributeNames.add(attributeName);
        }
        return modifiedAttributeNames;
    }

    private String _getName(long id) {
        try {
            T model = this.getModel(GetterUtil.getLong((Object)id));
            Map modelAttributes = model.getModelAttributes();
            return this._getName(String.valueOf(modelAttributes.get("name")));
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            return null;
        }
    }

    private String _getName(String name) {
        if (!name.startsWith("<?xml")) {
            return name;
        }
        Locale locale = LocaleUtil.getDefault();
        return LocalizationUtil.getLocalization((String)name, (String)locale.getLanguage());
    }

    private void _onAfterUpdateAssociation(Object classPK, String associationClassName, Object associationClassPK, String eventType) {
        block7: {
            String modelClassName = this.getModelClassName();
            if (modelClassName == null || !associationClassName.equals(User.class.getName())) {
                return;
            }
            try {
                T model = this.getModel((Long)classPK);
                if (this.isExcluded(model)) {
                    return;
                }
                User user = this.userLocalService.fetchUser(((Long)associationClassPK).longValue());
                if (!eventType.equals("deleteAssociation") && this.isUserExcluded(user)) {
                    return;
                }
                if (!eventType.equals("deleteAssociation")) {
                    List<String> userAttributeNames = this.getUserAttributeNames(user.getCompanyId());
                    userAttributeNames.add("associations");
                    userAttributeNames.add("userId");
                    this.addAnalyticsMessage("update", userAttributeNames, user);
                    if (user.fetchContact() != null) {
                        AnalyticsConfiguration analyticsConfiguration = this.analyticsConfigurationTracker.getAnalyticsConfiguration(user.getCompanyId());
                        this.addAnalyticsMessage("update", Arrays.asList(analyticsConfiguration.syncedContactFieldNames()), user.fetchContact());
                    }
                }
                Map modelAttributes = model.getModelAttributes();
                long companyId = (Long)modelAttributes.get("companyId");
                AnalyticsMessage.Builder analyticsMessageBuilder = AnalyticsMessage.builder(this.getModelClassName());
                analyticsMessageBuilder.action(eventType);
                analyticsMessageBuilder.object(JSONUtil.put((String)"classPK", (Object)classPK).put("emailAddress", user.getEmailAddress()).put("userId", associationClassPK));
                String analyticsMessageJSON = analyticsMessageBuilder.buildJSONString();
                this.analyticsMessageLocalService.addAnalyticsMessage(companyId, this.userLocalService.getDefaultUserId(companyId), analyticsMessageJSON.getBytes(Charset.defaultCharset()));
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Object)String.format("Unable to get %s %s", modelClassName, classPK), (Throwable)exception);
            }
        }
    }
}

