/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.dxp.entity.rest.internal.dto.v1_0.converter;

import com.liferay.analytics.dxp.entity.rest.dto.v1_0.DXPEntity;
import com.liferay.analytics.dxp.entity.rest.dto.v1_0.ExpandoField;
import com.liferay.analytics.dxp.entity.rest.dto.v1_0.Field;
import com.liferay.analytics.dxp.entity.rest.dto.v1_0.converter.DXPEntityDTOConverter;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationRegistry;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoColumnConstants;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.analytics.dxp.entity.rest.dto.v1_0.DXPEntity"}, service={DTOConverter.class, DXPEntityDTOConverter.class})
public class DXPEntityDTOConverterImpl
implements DXPEntityDTOConverter {
    private static final Log _log = LogFactoryUtil.getLog(DXPEntityDTOConverterImpl.class);
    @Reference
    private AnalyticsConfigurationRegistry _analyticsConfigurationRegistry;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;

    public String getContentType() {
        return DXPEntity.class.getSimpleName();
    }

    public DXPEntity toDTO(DTOConverterContext dtoConverterContext, BaseModel<?> baseModel) throws Exception {
        Map modelAttributes = baseModel.getModelAttributes();
        return this._toDXPEntity(this._getExpandoFields(baseModel), this._getFields(baseModel), String.valueOf(baseModel.getPrimaryKeyObj()), (Date)modelAttributes.get("modifiedDate"), baseModel.getModelClassName());
    }

    private void _addFieldAttributes(BaseModel<?> baseModel, List<Field> fields, List<String> includeAttributeNames) {
        Map modelAttributes = baseModel.getModelAttributes();
        for (final Map.Entry entry : modelAttributes.entrySet()) {
            if (ListUtil.isNotEmpty(includeAttributeNames) && !includeAttributeNames.contains(entry.getKey())) continue;
            Field field = new Field(){
                {
                    this.name = (String)entry.getKey();
                    this.value = entry.getValue();
                    if (this.value instanceof Date) {
                        Date date = (Date)this.value;
                        this.value = date.getTime();
                    }
                }
            };
            fields.add(field);
        }
    }

    private List<String> _filterAttributeNames(List<String> attributeNames, List<String> removeAttributeNames) {
        ArrayList<String> filteredAttributeNames = new ArrayList<String>();
        for (String attributeName : attributeNames) {
            if (removeAttributeNames.contains(attributeName)) continue;
            filteredAttributeNames.add(attributeName);
        }
        return filteredAttributeNames;
    }

    private Map<String, Serializable> _getAttributes(ExpandoBridge expandoBridge, List<String> includeAttributeNames) {
        HashMap<String, Serializable> newAttributes = new HashMap<String, Serializable>();
        Map attributes = expandoBridge.getAttributes(false);
        for (Map.Entry entry : attributes.entrySet()) {
            if (ListUtil.isNotEmpty(includeAttributeNames) && !includeAttributeNames.contains(entry.getKey())) continue;
            String dataType = ExpandoColumnConstants.getDataType((int)expandoBridge.getAttributeType((String)entry.getKey()));
            if (Validator.isBlank((String)dataType)) {
                dataType = "Text";
            }
            newAttributes.put((String)entry.getKey() + "-" + dataType, (Serializable)entry.getValue());
        }
        return newAttributes;
    }

    private Field[] _getExpandoColumnFields(final String className, final String dataType, final ExpandoColumn expandoColumn) {
        ArrayList<Field> fields = new ArrayList<Field>(){
            {
                this.add(new Field(){
                    {
                        this.name = "className";
                        this.value = className;
                    }
                });
                this.add(new Field(){
                    {
                        this.name = "columnId";
                        this.value = expandoColumn.getColumnId();
                    }
                });
                this.add(new Field(){
                    {
                        this.name = "dataType";
                        this.value = dataType;
                    }
                });
                this.add(new Field(){
                    {
                        this.name = "modifiedDate";
                        Date modifiedDate = expandoColumn.getModifiedDate();
                        this.value = modifiedDate.getTime();
                    }
                });
                this.add(new Field(){
                    {
                        this.name = "name";
                        this.value = expandoColumn.getName() + "-" + dataType;
                    }
                });
            }
        };
        return fields.toArray(new Field[0]);
    }

    private ExpandoField[] _getExpandoFields(BaseModel<?> baseModel) {
        if (!StringUtil.equals((String)baseModel.getModelClassName(), (String)Organization.class.getName()) && !StringUtil.equals((String)baseModel.getModelClassName(), (String)User.class.getName())) {
            return new ExpandoField[0];
        }
        ArrayList<3> expandoFields = new ArrayList<3>();
        List<String> includeAttributeNames = new ArrayList<String>();
        ShardedModel shardedModel = (ShardedModel)baseModel;
        if (StringUtil.equals((String)baseModel.getModelClassName(), (String)User.class.getName())) {
            AnalyticsConfiguration analyticsConfiguration = this._analyticsConfigurationRegistry.getAnalyticsConfiguration(shardedModel.getCompanyId());
            includeAttributeNames = ListUtil.fromArray((Object[])analyticsConfiguration.syncedUserFieldNames());
        }
        Map<String, Serializable> attributes = this._getAttributes(baseModel.getExpandoBridge(), includeAttributeNames);
        for (final Map.Entry<String, Serializable> entry : attributes.entrySet()) {
            final String key = entry.getKey();
            final ExpandoColumn expandoColumn = this._expandoColumnLocalService.getDefaultTableColumn(shardedModel.getCompanyId(), baseModel.getModelClassName(), key.substring(0, key.indexOf("-")));
            if (expandoColumn == null) continue;
            ExpandoField expandoField = new ExpandoField(){
                {
                    this.columnId = expandoColumn.getColumnId();
                    this.name = key;
                    this.value = DXPEntityDTOConverterImpl.this._parseValue(entry.getValue());
                }
            };
            expandoFields.add(expandoField);
        }
        return expandoFields.toArray(new ExpandoField[0]);
    }

    private Field[] _getFields(BaseModel<?> baseModel) throws Exception {
        if (StringUtil.equals((String)baseModel.getModelClassName(), (String)ExpandoColumn.class.getName())) {
            String dataType;
            ExpandoColumn expandoColumn = (ExpandoColumn)baseModel;
            String className = User.class.getName();
            if (this._isCustomField(Organization.class.getName(), expandoColumn.getTableId())) {
                className = Organization.class.getName();
            }
            if (Validator.isBlank((String)(dataType = ExpandoColumnConstants.getDataType((int)expandoColumn.getType())))) {
                dataType = "Text";
            }
            return this._getExpandoColumnFields(className, dataType, expandoColumn);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        List<String> includeAttributeNames = new ArrayList<String>();
        if (StringUtil.equals((String)baseModel.getModelClassName(), (String)User.class.getName())) {
            User user = (User)baseModel;
            AnalyticsConfiguration analyticsConfiguration = this._analyticsConfigurationRegistry.getAnalyticsConfiguration(user.getCompanyId());
            includeAttributeNames = ListUtil.fromArray((Object[])analyticsConfiguration.syncedUserFieldNames());
            this._addFieldAttributes((BaseModel<?>)user.getContact(), (List<Field>)fields, this._filterAttributeNames(ListUtil.fromArray((Object[])analyticsConfiguration.syncedContactFieldNames()), includeAttributeNames));
        }
        this._addFieldAttributes(baseModel, fields, includeAttributeNames);
        if (StringUtil.equals((String)baseModel.getModelClassName(), (String)Organization.class.getName())) {
            Field field = new Field();
            field.setName("parentOrganizationName");
            Organization organization = (Organization)baseModel;
            field.setValue((Object)organization.getParentOrganizationName());
            fields.add(field);
        }
        if (StringUtil.equals((String)baseModel.getModelClassName(), (String)Group.class.getName())) {
            for (Field field : fields) {
                if (!StringUtil.equals((String)field.getName(), (String)"name")) continue;
                Group group = (Group)baseModel;
                field.setValue((Object)group.getNameCurrentValue());
                break;
            }
        }
        return fields.toArray(new Field[0]);
    }

    private boolean _isCustomField(String className, long tableId) {
        block3: {
            long classNameId = this._classNameLocalService.getClassNameId(className);
            try {
                ExpandoTable expandoTable = this._expandoTableLocalService.getTable(tableId);
                if (Objects.equals("CUSTOM_FIELDS", expandoTable.getName()) && expandoTable.getClassNameId() == classNameId) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to get expando table " + tableId), (Throwable)exception);
            }
        }
        return false;
    }

    private String _parseValue(Object value) {
        if (value != null) {
            Class<?> clazz = value.getClass();
            if (!clazz.isArray()) {
                return String.valueOf(value);
            }
            ArrayList<Object> objects = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                objects.add(Array.get(value, i));
            }
            return "[" + StringUtil.merge((Object[])objects.toArray(), (String)",") + "]";
        }
        return null;
    }

    private DXPEntity _toDXPEntity(ExpandoField[] expandoFields, Field[] fields, String id, Date modifiedDate, String type) {
        DXPEntity dxpEntity = new DXPEntity();
        if (expandoFields == null) {
            expandoFields = new ExpandoField[]{};
        }
        dxpEntity.setExpandoFields(expandoFields);
        if (fields == null) {
            fields = new Field[]{};
        }
        dxpEntity.setFields(fields);
        dxpEntity.setId(id);
        dxpEntity.setModifiedDate(modifiedDate);
        dxpEntity.setType(type);
        return dxpEntity;
    }
}

