/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.batch.exportimport.internal.engine;

import com.liferay.analytics.batch.exportimport.internal.engine.BaseAnalyticsDXPEntityBatchEngineTaskItemDelegate;
import com.liferay.analytics.dxp.entity.rest.dto.v1_0.DXPEntity;
import com.liferay.analytics.dxp.entity.rest.dto.v1_0.converter.DXPEntityDTOConverter;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.configuration.AnalyticsConfigurationRegistry;
import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.pagination.Page;
import com.liferay.batch.engine.pagination.Pagination;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"batch.engine.task.item.delegate.name=user-analytics-dxp-entities"}, service={BatchEngineTaskItemDelegate.class})
public class UserAnalyticsDXPEntityBatchEngineTaskItemDelegate
extends BaseAnalyticsDXPEntityBatchEngineTaskItemDelegate<DXPEntity> {
    @Reference
    private AnalyticsConfigurationRegistry _analyticsConfigurationRegistry;
    @Reference
    private DXPEntityDTOConverter _dxpEntityDTOConverter;
    @Reference
    private UserLocalService _userLocalService;

    public Page<DXPEntity> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        com.liferay.portal.vulcan.pagination.Pagination vulcanPagination = com.liferay.portal.vulcan.pagination.Pagination.of((int)pagination.getPage(), (int)pagination.getPageSize());
        com.liferay.portal.vulcan.pagination.Page page = SearchUtil.search(null, booleanQuery -> booleanQuery.getPreBooleanFilter(), (Filter)this._createBooleanFilter(this.contextCompany.getCompanyId(), filter), (String)User.class.getName(), null, (com.liferay.portal.vulcan.pagination.Pagination)vulcanPagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setUserId(0L);
        }, (Sort[])sorts, document -> (DXPEntity)this._dxpEntityDTOConverter.toDTO((Object)this._userLocalService.getUser(GetterUtil.getLong((String)document.get("entryClassPK")))));
        return Page.of((Collection)page.getItems(), (Pagination)Pagination.of((int)pagination.getPage(), (int)pagination.getPageSize()), (long)page.getTotalCount());
    }

    private BooleanFilter _createBooleanFilter(long companyId, Filter filter) {
        Object[] syncedGroupIds;
        BooleanFilter booleanFilter = new BooleanFilter();
        if (filter != null) {
            booleanFilter.add(filter, BooleanClauseOccur.MUST);
        }
        booleanFilter.add((Filter)new TermFilter("screenName", "analytics.administrator"), BooleanClauseOccur.MUST_NOT);
        booleanFilter.add((Filter)new TermFilter("status", String.valueOf(5)), BooleanClauseOccur.MUST_NOT);
        AnalyticsConfiguration analyticsConfiguration = this._analyticsConfigurationRegistry.getAnalyticsConfiguration(companyId);
        if (analyticsConfiguration.syncAllContacts()) {
            return booleanFilter;
        }
        BooleanFilter innerBooleanFilter = new BooleanFilter();
        Object[] syncedOrganizationIds = analyticsConfiguration.syncedOrganizationIds();
        if (!ArrayUtil.isEmpty((Object[])syncedOrganizationIds)) {
            TermsFilter termsFilter = new TermsFilter("organizationIds");
            termsFilter.addValues((String[])syncedOrganizationIds);
            innerBooleanFilter.add((Filter)termsFilter);
        }
        if (!ArrayUtil.isEmpty((Object[])(syncedGroupIds = analyticsConfiguration.syncedUserGroupIds()))) {
            TermsFilter termsFilter = new TermsFilter("userGroupIds");
            termsFilter.addValues((String[])syncedGroupIds);
            innerBooleanFilter.add((Filter)termsFilter);
        }
        booleanFilter.add((Filter)innerBooleanFilter, BooleanClauseOccur.MUST);
        return booleanFilter;
    }
}

