/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.batch.exportimport.internal.engine;

import com.liferay.analytics.batch.exportimport.internal.engine.BaseAnalyticsDXPEntityBatchEngineTaskItemDelegate;
import com.liferay.analytics.dxp.entity.rest.dto.v1_0.DXPEntity;
import com.liferay.analytics.dxp.entity.rest.dto.v1_0.converter.DXPEntityDTOConverter;
import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.pagination.Page;
import com.liferay.batch.engine.pagination.Pagination;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"batch.engine.task.item.delegate.name=expando-column-analytics-dxp-entities"}, service={BatchEngineTaskItemDelegate.class})
public class ExpandoColumnAnalyticsDXPEntityBatchEngineTaskItemDelegate
extends BaseAnalyticsDXPEntityBatchEngineTaskItemDelegate<DXPEntity> {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private DXPEntityDTOConverter _dxpEntityDTOConverter;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;

    public Page<DXPEntity> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        DynamicQuery dynamicQuery = this._buildDynamicQuery(this.contextCompany.getCompanyId(), filter);
        if (dynamicQuery == null) {
            return Page.of(Collections.emptyList(), (Pagination)pagination, (long)0L);
        }
        ArrayList<Object> dxpEntities = new ArrayList<Object>();
        List expandoColumns = this._expandoColumnLocalService.dynamicQuery(dynamicQuery, pagination.getStartPosition(), pagination.getEndPosition());
        for (ExpandoColumn expandoColumn : expandoColumns) {
            dxpEntities.add(this._dxpEntityDTOConverter.toDTO((Object)expandoColumn));
        }
        return Page.of(dxpEntities, (Pagination)pagination, (long)this._expandoColumnLocalService.dynamicQueryCount(dynamicQuery));
    }

    private DynamicQuery _buildDynamicQuery(long companyId, Filter filter) {
        ExpandoTable organizationExpandoTable = this._expandoTableLocalService.fetchTable(companyId, this._classNameLocalService.getClassNameId(Organization.class.getName()), "CUSTOM_FIELDS");
        ExpandoTable userExpandoTable = this._expandoTableLocalService.fetchTable(companyId, this._classNameLocalService.getClassNameId(User.class.getName()), "CUSTOM_FIELDS");
        if (organizationExpandoTable == null && userExpandoTable == null) {
            return null;
        }
        DynamicQuery dynamicQuery = this._expandoColumnLocalService.dynamicQuery();
        Property tableIdProperty = PropertyFactoryUtil.forName((String)"tableId");
        if (organizationExpandoTable != null && userExpandoTable != null) {
            dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)tableIdProperty.eq((Object)organizationExpandoTable.getTableId()), (Criterion)tableIdProperty.eq((Object)userExpandoTable.getTableId())));
        } else if (organizationExpandoTable != null) {
            dynamicQuery.add(tableIdProperty.eq((Object)organizationExpandoTable.getTableId()));
        } else {
            dynamicQuery.add(tableIdProperty.eq((Object)userExpandoTable.getTableId()));
        }
        return this.buildDynamicQuery(companyId, dynamicQuery, filter);
    }
}

